/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.signin.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Pattern;
import net.xmind.signin.internal.Messages;
import net.xmind.signin.internal.UpdateData;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.xmind.core.net.IDataStore;
import org.xmind.core.net.internal.EncodingUtils;
import org.xmind.core.net.internal.XMindNetRequest;
import org.xmind.core.net.util.LinkUtils;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.viewers.FileUtils;

public class XMindUpdater {
    public static final String SKIPPABLE_YES = "yes";
    public static final String SKIPPABLE_NO = "no";
    private static final String PLUGIN_ID = "net.xmind.signin";
    private static final IStatus OK = new Status(0, "net.xmind.signin", Status.OK_STATUS.getMessage());
    private static final IStatus CANCELED = new Status(8, "net.xmind.signin", Status.CANCEL_STATUS.getMessage());
    private static final int DOWNLOAD_ID = 1025;
    private static final int SKIP_ID = 1026;
    private static final int REMIND_ME_ID = 1027;
    private final Display display;
    private final IWorkbench workbench;
    private UpdateData data;
    private final boolean installPermitted;
    private final boolean downloadPermitted;
    private final String skippable;
    private XMindNetRequest checkVersionRequest = null;
    private XMindNetRequest downloadRequest = null;

    public XMindUpdater(IWorkbench workbench) {
        this(workbench, Display.getCurrent(), null, SKIPPABLE_NO, false, false);
    }

    public XMindUpdater(IWorkbench workbench, String skippable) {
        this(workbench, Display.getCurrent(), null, skippable, false, false);
    }

    public XMindUpdater(IWorkbench workbench, UpdateData data, String skippable, boolean installPermitted) {
        this(workbench, Display.getCurrent(), data, skippable, installPermitted, false);
    }

    public XMindUpdater(IWorkbench workbench, Display display, UpdateData data, String skippable, boolean installPermitted, boolean downloadPermitted) {
        this.workbench = workbench;
        if (display == null && workbench != null) {
            display = workbench.getDisplay();
        }
        this.display = display;
        this.data = data;
        this.installPermitted = installPermitted;
        this.downloadPermitted = downloadPermitted;
        this.skippable = skippable;
    }

    public void abort() {
        if (this.checkVersionRequest != null) {
            this.checkVersionRequest.abort();
        }
        if (this.downloadRequest != null) {
            this.downloadRequest.abort();
        }
    }

    public IStatus run(final IProgressMonitor monitor) {
        Display display = Display.getCurrent();
        if (display == null) {
            return this.runWithoutUI(monitor);
        }
        final IStatus[] result = new IStatus[]{null};
        Thread thread = new Thread(new Runnable(){

            public void run() {
                result[0] = XMindUpdater.this.runWithoutUI(monitor);
            }
        });
        thread.setName("Check For Software Updates (Forked)");
        thread.start();
        while (result[0] == null) {
            if (!display.isDisposed()) {
                display.readAndDispatch();
            }
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException interruptedException) {
                monitor.setCanceled(true);
                thread.interrupt();
                return CANCELED;
            }
        }
        return result[0];
    }

    private IStatus runWithoutUI(IProgressMonitor monitor) {
        IStatus installConfirmed;
        IStatus checked;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.data == null && !(checked = this.check((IProgressMonitor)subMonitor.newChild(1))).isOK()) {
            return checked;
        }
        if (this.data == null) {
            return CANCELED;
        }
        if (this.data.getInstallerFile() == null) {
            IStatus downloadConfirmed = this.confirmDownload(monitor);
            if (!downloadConfirmed.isOK()) {
                return downloadConfirmed;
            }
            IStatus downloaded = this.download((IProgressMonitor)subMonitor.newChild(79));
            if (!downloaded.isOK()) {
                return downloaded;
            }
        }
        if (!(installConfirmed = this.confirmInstall(monitor)).isOK()) {
            return installConfirmed;
        }
        IStatus installed = this.install((IProgressMonitor)subMonitor.newChild(19));
        if (!installed.isOK()) {
            return installed;
        }
        return OK;
    }

    private IStatus check(IProgressMonitor monitor) {
        XMindNetRequest request;
        monitor.beginTask(null, 1);
        monitor.subTask(Messages.XMindUpdater_Task_CheckForUpdates);
        IProduct product = Platform.getProduct();
        if (product == null || !"org.xmind.cathy.product".equals(product.getId())) {
            throw new IllegalStateException(Messages.XMindUpdater_Error_NoXMindProductFound);
        }
        String currentVersion = System.getProperty("org.xmind.product.version");
        if (currentVersion == null) {
            throw new IllegalStateException(Messages.XMindUpdater_Error_NoXMindProductVersionFound);
        }
        String currentBuildId = System.getProperty("org.xmind.product.buildid");
        String distribId = System.getProperty("org.xmind.product.distribution.id");
        if (distribId == null || "".equals(distribId)) {
            distribId = "cathy_portable";
        }
        this.checkVersionRequest = request = new XMindNetRequest();
        request.uri(LinkUtils.getLinkByLanguage((boolean)true, (boolean)false, (String)EncodingUtils.format((String)"/_api/checkVersion/%s", (Object[])new Object[]{currentVersion})));
        request.addParameter("distrib", (Object)distribId);
        if (currentBuildId != null) {
            request.addParameter("buildid", (Object)currentBuildId);
        }
        try {
            request.get();
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        if (monitor.isCanceled() || request.isAborted()) {
            return CANCELED;
        }
        if (request.getError() != null) {
            return XMindUpdater.error(request.getError(), request.getError().getLocalizedMessage());
        }
        monitor.done();
        int code = request.getStatusCode();
        IDataStore data = request.getData();
        if (code == 404) {
            return this.runInUI(monitor, new IRunnable(){

                public IStatus run(IProgressMonitor monitor) throws Exception {
                    MessageDialog.openInformation((Shell)XMindUpdater.this.getParentShell(), (String)Messages.XMindUpdater_DialogTitle, (String)Messages.XMindUpdater_Dialog_NoUpdatesFound);
                    return CANCELED;
                }
            });
        }
        if (code == 200) {
            String downloadURL;
            if (data != null && (downloadURL = data.getString("download")) != null) {
                this.data = UpdateData.createNewData();
                this.data.setDownloadURL(downloadURL);
                String allDownloadsURL = data.getString("allDownloads");
                if (allDownloadsURL == null) {
                    allDownloadsURL = String.valueOf(LinkUtils.getHostByLanguage((boolean)true, (boolean)false)) + "/xmind/downloads/";
                }
                this.data.setAllDownloadsURL(allDownloadsURL);
                this.data.setSize(data.getLong("size"));
                this.data.setVersion(data.getString("version"));
                this.data.setBuildId(data.getString("buildId"));
                this.data.setWhatsNew(data.getString("whatsNew"));
                this.data.setCanInstall(!data.getBoolean("canInstall"));
                return OK;
            }
            return XMindUpdater.error(null, NLS.bind((String)Messages.XMindUpdater_Error_FailedToCheck_with_responseText, (Object)request.getResponseText()));
        }
        return XMindUpdater.error(null, NLS.bind((String)Messages.XMindUpdater_Error_FailedToCheck_with_responseCode, (Object)code));
    }

    private IStatus confirmDownload(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return CANCELED;
        }
        if (this.downloadPermitted) {
            return OK;
        }
        monitor.subTask(Messages.XMindUpdater_Task_ConfirmDownloading);
        return this.runInUI(monitor, new IRunnable(){

            public IStatus run(IProgressMonitor monitor) throws Exception {
                ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.xmind.cathy");
                String version = XMindUpdater.this.data.getBuildId();
                if (XMindUpdater.SKIPPABLE_YES.equalsIgnoreCase(XMindUpdater.this.skippable) && preferenceStore.getString("needSkipVersion").equals(version)) {
                    return CANCELED;
                }
                int code = new NewUpdateDialog(XMindUpdater.this.getParentShell()).open();
                if (code == 1025) {
                    return OK;
                }
                if (code == 1026) {
                    preferenceStore.setValue("needSkipVersion", version == null ? "" : version);
                } else if (code == 1027) {
                    preferenceStore.setValue("needSkipVersion", "");
                }
                return CANCELED;
            }
        });
    }

    private IStatus download(IProgressMonitor monitor) {
        Throwable error;
        int status;
        XMindNetRequest request;
        File installerFile;
        if (monitor.isCanceled()) {
            return CANCELED;
        }
        final String downloadURL = this.data.getDownloadURL();
        if (downloadURL == null) {
            return CANCELED;
        }
        monitor.beginTask(null, 100);
        if (!this.data.canInstall()) {
            if (FileUtils.launch((String)downloadURL)) {
                return OK;
            }
            monitor.subTask(Messages.XMindUpdater_Task_ChooseSaveLocation);
            IStatus fileChosen = this.runInUI(monitor, new IRunnable(){

                public IStatus run(IProgressMonitor monitor) throws Exception {
                    FileDialog dialog = new FileDialog(XMindUpdater.this.getParentShell(), 8192);
                    dialog.setText(Messages.XMindUpdater_SaveDialogTitle);
                    dialog.setFileName(XMindUpdater.getFileName(downloadURL));
                    String path = dialog.open();
                    if (path == null) {
                        return CANCELED;
                    }
                    XMindUpdater.this.data.setInstallerFile(new File(path));
                    return OK;
                }
            });
            if (!fileChosen.isOK()) {
                return fileChosen;
            }
        }
        if ((installerFile = this.data.getInstallerFile()) == null) {
            installerFile = XMindUpdater.createTempInstallerFile(downloadURL);
            this.data.setInstallerFile(installerFile);
        }
        if (monitor.isCanceled()) {
            return CANCELED;
        }
        monitor.subTask(Messages.XMindUpdater_Task_Download);
        this.downloadRequest = request = new XMindNetRequest();
        request.uri(downloadURL);
        request.setTargetFile(this.data.getInstallerFile());
        final boolean[] finished = new boolean[]{false};
        Thread thread = new Thread(new Runnable(){

            public void run() {
                request.get();
                finished[0] = true;
            }
        });
        thread.setDaemon(true);
        thread.setName("Download XMind Software Updates");
        thread.setPriority(1);
        thread.start();
        int oldStatus = -1;
        int requestProgress = 0;
        int receivingProgress = 0;
        while (!finished[0]) {
            long bytes;
            int newProgress;
            long total;
            if (monitor.isCanceled()) {
                request.abort();
                return CANCELED;
            }
            if (request.isAborted()) {
                monitor.setCanceled(true);
                return CANCELED;
            }
            status = request.getStatusCode();
            error = request.getError();
            if (error != null) {
                return XMindUpdater.error(error, NLS.bind((String)Messages.XMindUpdater_Error_FailedToDownload_with_errorDescription, (Object)error.getLocalizedMessage()));
            }
            if (status != oldStatus) {
                int newProgress2 = requestProgress;
                if (status == 0) {
                    newProgress2 = 0;
                } else if (status == 1) {
                    newProgress2 = 5;
                } else if (status == 2) {
                    newProgress2 = 10;
                } else if (status == 3) {
                    newProgress2 = 15;
                } else if (status == 4) {
                    newProgress2 = 20;
                } else {
                    if (status == 999) {
                        return XMindUpdater.error(request.getError(), Messages.XMindUpdater_Error_FailedToDownloadUnknownError);
                    }
                    if (status == 200) break;
                    return XMindUpdater.error(request.getError(), NLS.bind((String)Messages.XMindUpdater_Error_FailedToDownloadUnknownError_with_responseCode, (Object)status));
                }
                monitor.worked(newProgress2 - requestProgress);
                requestProgress = newProgress2;
                oldStatus = status;
            }
            if (status == 4 && (total = request.getTotalBytes()) > 0L && (newProgress = (int)((double)(bytes = request.getTransferedBytes()) * 80.0 / (double)total)) > receivingProgress) {
                monitor.worked(newProgress - receivingProgress);
                monitor.subTask(NLS.bind((String)Messages.XMindUpdater_Task_DownloadProgress_with_percentage, (Object)String.format("%.2f", (double)bytes * 100.0 / (double)total)));
                receivingProgress = newProgress;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                monitor.setCanceled(true);
                return CANCELED;
            }
        }
        if (monitor.isCanceled()) {
            return CANCELED;
        }
        status = request.getStatusCode();
        error = request.getError();
        if (error != null) {
            return XMindUpdater.error(error, NLS.bind((String)Messages.XMindUpdater_Error_FailedToDownload_with_errorDescription, (Object)error.getLocalizedMessage()));
        }
        if (status == 999) {
            return XMindUpdater.error(request.getError(), Messages.XMindUpdater_Error_FailedToDownloadUnknownError);
        }
        if (status != 200) {
            return XMindUpdater.error(request.getError(), NLS.bind((String)Messages.XMindUpdater_Error_FailedToDownloadUnknownError_with_responseCode, (Object)status));
        }
        this.data.save();
        monitor.done();
        return OK;
    }

    private IStatus confirmInstall(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return CANCELED;
        }
        if (this.installPermitted) {
            return OK;
        }
        monitor.subTask(Messages.XMindUpdater_Task_ConfirmInstalling);
        return this.runInUI(monitor, new IRunnable(){

            public IStatus run(IProgressMonitor monitor) throws Exception {
                int choice = new MessageDialog(XMindUpdater.this.getParentShell(), Messages.XMindUpdater_DialogTitle, null, Messages.XMindUpdater_Dialog_ConfirmInstalling, 2, new String[]{Messages.XMindUpdater_Action_QuitAndInstall_text, Messages.XMindUpdater_Action_Later_text}, 0).open();
                if (choice == 0) {
                    return OK;
                }
                return CANCELED;
            }
        });
    }

    private IStatus install(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return CANCELED;
        }
        monitor.subTask(Messages.XMindUpdater_Task_LaunchInstaller);
        File installerFile = this.data.getInstallerFile();
        if (installerFile == null || !installerFile.exists()) {
            return CANCELED;
        }
        IStatus workbenchClosed = this.closeWorkbench(monitor);
        if (!workbenchClosed.isOK()) {
            return workbenchClosed;
        }
        if (!this.data.canInstall()) {
            return this.launchInstallerFile(monitor, installerFile);
        }
        IStatus launched = this.launchUpdater(monitor, installerFile);
        if (!launched.isOK()) {
            return launched;
        }
        return OK;
    }

    private IStatus launchInstallerFile(IProgressMonitor monitor, final File installerFile) {
        if (monitor.isCanceled()) {
            return CANCELED;
        }
        if (this.display == null || this.display.isDisposed()) {
            return this.launchFile(monitor, installerFile);
        }
        return this.runInUI(monitor, new IRunnable(){

            public IStatus run(IProgressMonitor monitor) throws Exception {
                return XMindUpdater.this.launchFile(monitor, installerFile);
            }
        });
    }

    private IStatus launchFile(IProgressMonitor monitor, File file) {
        if (file == null) {
            return CANCELED;
        }
        if (!file.exists()) {
            return XMindUpdater.error(null, NLS.bind((String)Messages.XMindUpdater_Error_InstallerExecutableNotFound_with_executablePath, (Object)file.getAbsolutePath()));
        }
        if (file.canExecute()) {
            try {
                Runtime.getRuntime().exec(new String[]{file.getAbsolutePath()});
                return OK;
            }
            catch (IOException e) {
                return XMindUpdater.error(e, NLS.bind((String)Messages.XMindUpdater_Error_FailedToExecuteInstaller_with_errorDescription, (Object)e.getLocalizedMessage()));
            }
        }
        if (!FileUtils.launch((String)file.getAbsolutePath())) {
            FileUtils.show((File)file);
        }
        return OK;
    }

    private IStatus launchUpdater(IProgressMonitor monitor, File installerFile) {
        if (monitor.isCanceled()) {
            return CANCELED;
        }
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            return this.updateOnWindows(monitor, installerFile);
        }
        if ("macosx".equals(os)) {
            return this.updateOnMacOSX(monitor, installerFile);
        }
        if ("linux".equals(os)) {
            return this.updateOnLinux(monitor, installerFile);
        }
        return this.launchInstallerFile(monitor, installerFile);
    }

    private IStatus updateOnWindows(IProgressMonitor monitor, File installerFile) {
        return this.launchShell(monitor, installerFile.getAbsolutePath(), "/SILENT", "/mode=update");
    }

    private IStatus updateOnMacOSX(IProgressMonitor monitor, File installerFile) {
        String scriptPath;
        String appPath;
        if (installerFile.getName().endsWith(".dmg") && (appPath = XMindUpdater.findAppPath()) != null && (scriptPath = this.generateUpdateScriptOnMacOSX(installerFile, appPath)) != null) {
            try {
                Runtime.getRuntime().exec(new String[]{"open", scriptPath});
                return OK;
            }
            catch (IOException iOException) {}
        }
        FileUtils.launch((String)installerFile.getAbsolutePath());
        return OK;
    }

    private String generateUpdateScriptOnMacOSX(File installerFile, String appPath) {
        String tempAppPath = String.valueOf(appPath.substring(0, appPath.length() - 4)) + " (previous version).app";
        String quotedAppPath = XMindUpdater.quote(appPath);
        String quotedTempAppPath = XMindUpdater.quote(tempAppPath);
        String quotedDMGPath = XMindUpdater.quote(installerFile.getAbsolutePath());
        String workspacePath = XMindUpdater.getWorkspacePath();
        try {
            String quotedLogPath = workspacePath == null ? XMindUpdater.quote(File.createTempFile("updatexmind", ".log").getAbsolutePath()) : XMindUpdater.quote(String.valueOf(workspacePath) + "/updatexmind.log");
            File script = File.createTempFile("xmind-update", ".sh");
            ScriptWriter writer = new ScriptWriter(script);
            try {
                writer.line("#!/bin/bash", new Object[0]);
                writer.line("mv %s %s", quotedAppPath, quotedTempAppPath);
                writer.line("hdiutil mount -nobrowse -quiet %s", quotedDMGPath);
                writer.line("cp -R \"/Volumes/XMind/XMind.app\" /Applications >> %s", quotedLogPath);
                String ascript = "tell app \"Finder\" to delete POSIX file " + quotedTempAppPath;
                writer.line("osascript -e %s >> %s", XMindUpdater.quote(ascript), quotedLogPath);
                writer.line("hdiutil unmount -quiet \"/Volumes/XMind/\"", new Object[0]);
                writer.line("rm -rf %s", quotedDMGPath);
                writer.line("open \"/Applications/XMind.app\"", new Object[0]);
            }
            finally {
                writer.close();
            }
            return script.getAbsolutePath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private IStatus updateOnLinux(IProgressMonitor monitor, File installerFile) {
        FileUtils.show((File)installerFile);
        return OK;
    }

    private Shell getParentShell() {
        IWorkbenchWindow window;
        if (this.workbench != null && (window = this.workbench.getActiveWorkbenchWindow()) != null) {
            return window.getShell();
        }
        return Display.getCurrent().getActiveShell();
    }

    private static String findAppPath() {
        File appLocation;
        String installPath = XMindUpdater.getInstallPath();
        if (installPath != null && (appLocation = XMindUpdater.findAppLocation(new File(installPath))) != null) {
            return appLocation.getAbsolutePath();
        }
        return null;
    }

    private static String getInstallPath() {
        Location location = Platform.getInstallLocation();
        if (location == null) {
            return null;
        }
        URL url = location.getURL();
        if (url == null) {
            return null;
        }
        try {
            return FileLocator.toFileURL((URL)url).getFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String getWorkspacePath() {
        Location location = Platform.getInstanceLocation();
        if (location == null) {
            return null;
        }
        URL url = location.getURL();
        if (url == null) {
            return null;
        }
        try {
            return FileLocator.toFileURL((URL)url).getFile();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static File findAppLocation(File location) {
        if (location == null) {
            return null;
        }
        String name = location.getName();
        if (name.endsWith(".app")) {
            return location;
        }
        if ("Resources".equals(name) || "Contents".equals(name)) {
            return XMindUpdater.findAppLocation(location.getParentFile());
        }
        return null;
    }

    private static String quote(String path) {
        return "\"" + path.replaceAll("\\", "\\\\").replaceAll("\"", "\\\"") + "\"";
    }

    private IStatus launchShell(IProgressMonitor monitor, String ... commands) {
        try {
            Runtime.getRuntime().exec(commands);
            return OK;
        }
        catch (IOException e) {
            return XMindUpdater.error(e, NLS.bind((String)Messages.XMindUpdater_Error_FailedToExecuteCommand_with_commandLine, (Object)XMindUpdater.getCommandLine(commands)));
        }
    }

    private static String getCommandLine(String ... args) {
        StringBuffer buffer = new StringBuffer(args.length * 15);
        int i = 0;
        while (i < args.length) {
            if (i == 0) {
                buffer.append(args[i]);
            } else {
                buffer.append(' ');
                buffer.append('\"');
                buffer.append(args[i]);
                buffer.append('\"');
            }
            ++i;
        }
        return buffer.toString();
    }

    private IStatus closeWorkbench(IProgressMonitor monitor) {
        return this.workbench == null || this.display == null || this.display.isDisposed() ? OK : this.runInUI(monitor, new IRunnable(){

            public IStatus run(IProgressMonitor monitor) throws Exception {
                if (XMindUpdater.this.workbench != null && !XMindUpdater.this.workbench.close()) {
                    return CANCELED;
                }
                return OK;
            }
        });
    }

    private IStatus runInUI(final IProgressMonitor monitor, final IRunnable runnable) {
        if (this.display == null || this.display.isDisposed()) {
            return CANCELED;
        }
        final IStatus[] result = new IStatus[]{null};
        this.display.syncExec(new Runnable(){

            public void run() {
                try {
                    result[0] = runnable.run(monitor);
                }
                catch (Throwable e) {
                    result[0] = XMindUpdater.error(e, e.getLocalizedMessage());
                }
            }
        });
        if (monitor.isCanceled()) {
            return CANCELED;
        }
        if (result[0] != null) {
            return result[0];
        }
        return OK;
    }

    private static File createTempInstallerFile(String downloadURL) {
        File dir = UpdateData.getUpdateFolder();
        String fileName = XMindUpdater.getFileName(downloadURL);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return new File(dir, fileName);
    }

    private static String getFileName(String downloadURL) {
        String path;
        try {
            path = new URI(downloadURL).getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            int j = downloadURL.lastIndexOf(63);
            path = j < 0 ? downloadURL : downloadURL.substring(0, j);
        }
        int i = path.lastIndexOf(47);
        if (i < 0) {
            return path;
        }
        return path.substring(i + 1);
    }

    private static IStatus error(Throwable exception, String message) {
        return new Status(2, PLUGIN_ID, message, exception);
    }

    public static boolean checkSoftwareUpdateOnStart() {
        String currentVersion = System.getProperty("org.xmind.product.version");
        if (currentVersion == null) {
            return false;
        }
        UpdateData data = UpdateData.loadData();
        if (data == null) {
            return false;
        }
        String newVersion = data.getVersion();
        if (newVersion == null || XMindUpdater.compareVersion(currentVersion, newVersion) >= 0) {
            UpdateData.clear();
            return false;
        }
        File installerFile = data.getInstallerFile();
        if (installerFile == null || !installerFile.exists()) {
            UpdateData.clear();
            return false;
        }
        int choice = new MessageDialog(null, Messages.XMindUpdater_DialogTitle, null, Messages.XMindUpdater_Dialog_ConfirmInstallingOnStartupCheck, 2, new String[]{Messages.XMindUpdater_Action_Install_text, Messages.XMindUpdater_Action_Clear_text, Messages.XMindUpdater_Action_Later_text}, 0).open();
        if (choice == 1 && MessageDialog.openQuestion(null, (String)Messages.XMindUpdater_DialogTitle, (String)Messages.XMindUpdater_Dialog_ConfirmClearDownload)) {
            UpdateData.clear();
        }
        if (choice != 0) {
            return false;
        }
        return new XMindUpdater(null, data, SKIPPABLE_NO, true).run((IProgressMonitor)new NullProgressMonitor()).isOK();
    }

    private static int compareVersion(String version1, String version2) {
        Pattern sep = Pattern.compile("\\.");
        String[] v1 = sep.split(version1);
        String[] v2 = sep.split(version2);
        int m = Math.max(v1.length, v2.length);
        StringBuffer s1 = new StringBuffer(32);
        StringBuffer s2 = new StringBuffer(32);
        String e = "";
        int i = 0;
        while (i < m) {
            String p1 = i < v1.length ? v1[i] : e;
            String p2 = i < v2.length ? v2[i] : e;
            int t = Math.max(p1.length(), p2.length());
            int j = 0;
            while (j < t) {
                if (j < t - p1.length()) {
                    s1.append('0');
                }
                if (j < t - p2.length()) {
                    s2.append('0');
                }
                ++j;
            }
            s1.append(p1);
            s2.append(p2);
            ++i;
        }
        return s1.toString().compareTo(s2.toString());
    }

    private static interface IRunnable {
        public IStatus run(IProgressMonitor var1) throws Exception;
    }

    private class NewUpdateDialog
    extends Dialog {
        private String whatsNew;
        private boolean hasWhatsNew;

        public NewUpdateDialog(Shell parentShell) {
            super(parentShell);
            this.whatsNew = XMindUpdater.this.data.getWhatsNew();
            this.hasWhatsNew = this.whatsNew != null && !"".equals(this.whatsNew);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.XMindUpdater_NewDialog_Title);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.createIconAndMessages(composite);
            return composite;
        }

        private void createIconAndMessages(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.widthHint = -1;
            gridData.heightHint = -1;
            composite.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 5;
            gridLayout.marginHeight = 5;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 20;
            composite.setLayout((Layout)gridLayout);
            this.createIcon(composite);
            this.createMessages(composite);
        }

        private void createIcon(Composite parent) {
            Label label = new Label(parent, 0);
            label.setLayoutData((Object)new GridData(1, 1, false, false));
            ImageDescriptor imgDesc = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.xmind.cathy", (String)"icons/xmind.48.png");
            if (imgDesc != null) {
                final Image img = imgDesc.createImage();
                label.setImage(img);
                label.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        img.dispose();
                    }
                });
            } else {
                label.setImage(parent.getDisplay().getSystemImage(2));
            }
        }

        private void createMessages(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridData gridData = new GridData(4, 4, true, true);
            gridData.widthHint = 400;
            gridData.heightHint = this.hasWhatsNew ? 200 : -1;
            composite.setLayoutData((Object)gridData);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 10;
            gridLayout.horizontalSpacing = 0;
            composite.setLayout((Layout)gridLayout);
            this.createMessageArea(composite);
            this.createSpecArea(composite);
            this.createWhatsNewArea(composite);
        }

        private void createMessageArea(Composite parent) {
            Label label = new Label(parent, 64);
            label.setLayoutData((Object)new GridData(4, 1, true, false));
            label.setText(Messages.XMindUpdater_Dialog_NewVersionAvailable);
            label.setFont(FontUtils.getBoldRelative((String)"org.eclipse.jface.defaultfont", (int)1));
        }

        private void createSpecArea(Composite parent) {
            Label label = new Label(parent, 64);
            label.setLayoutData((Object)new GridData(4, 1, true, false));
            label.setText(NLS.bind((String)Messages.XMindUpdater_NewDialog_NewVersionLabel, (Object)XMindUpdater.this.data.getBuildId()));
        }

        private void createWhatsNewArea(Composite parent) {
            if (!this.hasWhatsNew) {
                return;
            }
            Text text = new Text(parent, 2826);
            text.setLayoutData((Object)new GridData(4, 4, true, true));
            text.setText(this.whatsNew);
            text.setEditable(false);
        }

        protected Control createButtonBar(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.makeColumnsEqualWidth = false;
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.marginLeft = 60;
            composite.setLayout((Layout)layout);
            GridData data = new GridData(4, 4, true, false);
            composite.setLayoutData((Object)data);
            composite.setFont(parent.getFont());
            this.createLeftButtonBar(composite);
            return super.createButtonBar(composite);
        }

        private Composite createLeftButtonBar(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 0;
            layout.makeColumnsEqualWidth = true;
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            GridData data = new GridData(16384, 0x1000000, true, false);
            composite.setLayoutData((Object)data);
            composite.setFont(parent.getFont());
            this.createLeftButtons(composite);
            return composite;
        }

        private void createLeftButtons(Composite parent) {
            this.createButton(parent, 1026, Messages.XMindUpdater_NewDialog_SkipLabel, false);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 1027, Messages.XMindUpdater_NewDialog_RemindLaterLabel, false);
            this.createButton(parent, 1025, Messages.XMindUpdater_NewDialog_UpdateLabel, true).setFocus();
        }

        protected void buttonPressed(int buttonId) {
            this.setReturnCode(buttonId);
            this.close();
        }
    }

    private static class ScriptWriter {
        private PrintStream ps;

        public ScriptWriter(File file) throws FileNotFoundException {
            this.ps = new PrintStream(file);
        }

        public void line(String line, Object ... args) throws IOException {
            if (args.length == 0) {
                this.ps.println(line);
            } else {
                this.ps.println(String.format(line, args));
            }
        }

        public void close() throws IOException {
            this.ps.close();
        }
    }
}

