/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.dashboard;

import java.net.URI;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.xmind.cathy.internal.dashboard.RecentFilesContentProvider;
import org.xmind.cathy.internal.dashboard.RecentFilesGalleryPartFactory;
import org.xmind.cathy.internal.dashboard.RecentFilesLabelProvider;
import org.xmind.gef.EditDomain;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.internal.SpaceCollaborativeEngine;
import org.xmind.gef.util.Properties;
import org.xmind.ui.editor.IEditorHistory;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GalleryNavigablePolicy;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.resources.ColorUtils;

public class RecentFileViewer
extends GalleryViewer {
    private static final int FRAME_WIDTH = 210;
    private static final int FRAME_HEIGHT = 130;
    private static final String COLOR_CONTENT_BORDER = "#cccccc";
    private IEditorHistory editorHistory = (IEditorHistory)PlatformUI.getWorkbench().getService(IEditorHistory.class);
    private LocalResourceManager resources;
    private Control viewerControl;
    private RecentFilesContentProvider contentProvider;

    public RecentFileViewer(Composite parent) {
        this.initViewer(parent);
        this.registerHelper(parent.getShell());
    }

    private void registerHelper(Shell shell) {
        shell.setData("org.xmind.ui.helper.recentFile.pin", (Object)new Runnable(){

            @Override
            public void run() {
                ISelection selection = RecentFileViewer.this.getSelection();
                if (selection instanceof IStructuredSelection) {
                    List list = ((IStructuredSelection)selection).toList();
                    for (Object element : list) {
                        if (!(element instanceof URI)) continue;
                        boolean isChecked = RecentFileViewer.this.editorHistory.isPinned((URI)element);
                        if (isChecked) {
                            RecentFileViewer.this.unPinRecentFile((URI)element);
                            continue;
                        }
                        RecentFileViewer.this.pinRecentFile((URI)element);
                    }
                }
            }
        });
        shell.setData("org.xmind.ui.helper.recentFile.delete", (Object)new Runnable(){

            @Override
            public void run() {
                ISelection selection = RecentFileViewer.this.getSelection();
                if (selection instanceof IStructuredSelection) {
                    List list = ((IStructuredSelection)selection).toList();
                    for (Object element : list) {
                        if (!(element instanceof URI)) continue;
                        RecentFileViewer.this.deleteRecentFile((URI)element);
                    }
                }
            }
        });
        shell.setData("org.xmind.ui.helper.recentFile.clear", (Object)new Runnable(){

            @Override
            public void run() {
                RecentFileViewer.this.clearRecentFile();
            }
        });
    }

    private void unregisterHelper(Shell shell) {
        shell.setData("org.xmind.ui.helper.recentFile.clear", null);
        shell.setData("org.xmind.ui.helper.recentFile.delete", null);
        shell.setData("org.xmind.ui.helper.recentFile.pin", null);
    }

    private void handleDispose() {
        if (this.viewerControl != null && !this.viewerControl.isDisposed()) {
            this.unregisterHelper(this.viewerControl.getShell());
        }
        if (this.editorHistory != null) {
            this.editorHistory.removeEditorHistoryListener((IEditorHistory.IEditorHistoryListener)this.contentProvider);
        }
    }

    private void initViewer(final Composite parent) {
        if (this.resources == null) {
            this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        }
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new GallerySelectTool());
        editDomain.installEditPolicy("org.xmind.ui.gallery.editPolicy.navigable", (IEditPolicy)new GalleryNavigablePolicy());
        this.setEditDomain(editDomain);
        Properties properties = this.getProperties();
        properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_BOTTOM);
        properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.FALSE);
        properties.set("org.xmind.ui.gallery.solidFrames", true);
        properties.set("org.xmind.ui.gallery.flatFrames", true);
        properties.set("constrained", (Object)Boolean.TRUE);
        properties.set("stretched", (Object)Boolean.TRUE);
        properties.set("org.xmind.ui.gallery.contentPaneBorderWidth", 1);
        properties.set("org.xmind.ui.gallery.customDecorateContentPane", true);
        properties.set("org.xmind.ui.gallery.contentPaneBorderColor", this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)COLOR_CONTENT_BORDER)));
        properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(210, 130));
        properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 1, 30, 0, new Insets(10, 65, 20, 65)));
        properties.set("org.xmind.ui.gallery.contentPaneSpaceCollaborativeEngine", (Object)new SpaceCollaborativeEngine());
        this.contentProvider = new RecentFilesContentProvider();
        final RecentFilesLabelProvider labelProvider = new RecentFilesLabelProvider(parent);
        this.contentProvider.addContentChangeListener(new Runnable(){

            @Override
            public void run() {
                RecentFileViewer.this.handleRecentFileListChanged(RecentFileViewer.this.contentProvider, labelProvider, true);
                parent.layout(true);
            }
        });
        this.viewerControl = this.createControl(parent);
        this.viewerControl.setBackground(parent.getBackground());
        this.viewerControl.setForeground(parent.getForeground());
        this.viewerControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewerControl.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RecentFileViewer.this.handleDispose();
            }
        });
        this.setPartFactory((IPartFactory)new RecentFilesGalleryPartFactory());
        this.setContentProvider(this.contentProvider);
        this.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.editorHistory.addEditorHistoryListener((IEditorHistory.IEditorHistoryListener)this.contentProvider);
        this.setInput(this.editorHistory);
        this.handleRecentFileListChanged(this.contentProvider, labelProvider, true);
    }

    public Control getControl() {
        if (this.viewerControl != null) {
            return this.viewerControl;
        }
        return super.getControl();
    }

    private void handleRecentFileListChanged(RecentFilesContentProvider contentProvider, RecentFilesLabelProvider labelProvider, boolean refresh) {
        if (refresh) {
            this.setInput(this.getInput());
        }
    }

    private void clearRecentFile() {
        this.editorHistory.clear();
    }

    private void deleteRecentFile(URI fileURI) {
        this.editorHistory.remove(fileURI);
    }

    private void pinRecentFile(URI fileURI) {
        this.editorHistory.pin(fileURI);
        this.updateRecentFilePart(fileURI);
    }

    private void unPinRecentFile(URI fileURI) {
        this.editorHistory.unPin(fileURI);
        this.updateRecentFilePart(fileURI);
    }

    private void updateRecentFilePart(URI pinURI) {
        RecentFilesGalleryPartFactory.RecentFilesFramePart part = this.findRecentFilePart(pinURI);
        if (part != null) {
            part.update();
        }
    }

    private RecentFilesGalleryPartFactory.RecentFilesFramePart findRecentFilePart(URI pinURI) {
        if (pinURI == null) {
            return null;
        }
        return (RecentFilesGalleryPartFactory.RecentFilesFramePart)this.getPartRegistry().getPartByModel((Object)pinURI);
    }
}

