/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.xmind.cathy.internal.CathyPlugin;
import org.xmind.cathy.internal.WorkbenchMessages;
import org.xmind.core.net.util.LinkUtils;
import org.xmind.core.usagedata.IUsageDataSampler;
import org.xmind.core.usagedata.IUsageDataUploader;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.util.NumberUtils;

public class GeneralPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private Text autoSaveIntervalsInput;
    private boolean autoBackup = true;
    private BooleanFieldEditor autoBackupField;
    private IntegerFieldEditor recentFilesField;
    private Control recentFilesControl;
    private Button startupActionButton;
    private ResourceManager resources;

    public GeneralPrefPage() {
        super(WorkbenchMessages.GeneralPrefPage_title, 0);
    }

    public void applyData(Object data) {
        if ("RECENT_FILES".equals(data) && this.recentFilesControl != null && !this.recentFilesControl.isDisposed()) {
            this.recentFilesControl.setFocus();
            this.highlight((Control)this.recentFilesControl.getParent());
        }
    }

    private void highlight(final Control control) {
        final Display display = control.getDisplay();
        Color oldBackground = control.getBackground();
        Color c1 = oldBackground == null ? display.getSystemColor(22) : oldBackground;
        final int r1 = c1.getRed();
        final int g1 = c1.getGreen();
        final int b1 = c1.getBlue();
        final int[] step = new int[1];
        final Color[] c = new Color[1];
        display.timerExec(500, new Runnable(){

            @Override
            public void run() {
                if (control.isDisposed()) {
                    return;
                }
                c[0] = new Color((Device)display, 255, 240, 180);
                control.setBackground(c[0]);
                display.timerExec(20, new Runnable(){

                    @Override
                    public void run() {
                        c[0].dispose();
                        if (control.isDisposed()) {
                            return;
                        }
                        step[0] = step[0] + 1;
                        if (step[0] > 30) {
                            control.setBackground(null);
                            return;
                        }
                        int x = step[0];
                        int y = 30 - step[0];
                        int r = (255 * y + r1 * x) / 30;
                        int g = (240 * y + g1 * x) / 30;
                        int b = (180 * y + b1 * x) / 30;
                        c[0] = new Color((Device)display, r, g, b);
                        control.setBackground(c[0]);
                        display.timerExec(20, (Runnable)this);
                    }
                });
            }
        });
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CathyPlugin.getDefault().getPreferenceStore();
    }

    public void createControl(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        super.createControl(parent);
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        ((GridLayout)composite.getLayout()).verticalSpacing = 15;
        return composite;
    }

    protected void createFieldEditors() {
        this.addStartupGroup();
        this.addRecentFileCountField();
        this.addAutoSaveGroup();
        this.addAutoBackupGroup();
        this.addSendUsageDataGroup();
    }

    private void addStartupGroup() {
        Composite parent = this.createGroup(WorkbenchMessages.Startup_title);
        this.addStartupActionField(parent);
        this.addCheckUpdatesField(parent);
    }

    private void addStartupActionField(Composite parent) {
        this.startupActionButton = new Button(parent, 32);
        this.startupActionButton.setText(WorkbenchMessages.RestoreLastSession_label);
    }

    private void addCheckUpdatesField(Composite parent) {
        this.addField((FieldEditor)new BooleanFieldEditor("checkUpdatesOnStartup", WorkbenchMessages.CheckUpdates_label, this.createFieldContainer(parent, true)));
    }

    private void addRecentFileCountField() {
        Composite container = this.getFieldEditorParent();
        this.recentFilesField = new IntegerFieldEditor("RECENT_FILES", WorkbenchMessages.RecentFiles_label, container);
        this.addField((FieldEditor)this.recentFilesField);
        this.recentFilesControl = this.recentFilesField.getTextControl(container);
    }

    private void addAutoSaveGroup() {
        String label2;
        String label1;
        String message = WorkbenchMessages.AutoSave_label2;
        int index = message.indexOf("{0}");
        int cols = 3;
        if (index >= 0) {
            label1 = message.substring(0, index);
            label2 = message.substring(index + 3);
            if ("".equals(label2)) {
                label2 = null;
                --cols;
            }
        } else {
            label1 = message;
            label2 = null;
            --cols;
            if ("".equals(label1)) {
                label1 = null;
                --cols;
            }
        }
        Composite parent = this.getFieldEditorParent();
        GridLayout gridLayout = new GridLayout(cols, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        Composite booleanParent = new Composite(parent, 0);
        booleanParent.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        this.addField((FieldEditor)new BooleanFieldEditor("autoSaveEnabled", label1, booleanParent));
        this.autoSaveIntervalsInput = new Text(parent, 16779268);
        this.autoSaveIntervalsInput.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        ((GridData)this.autoSaveIntervalsInput.getLayoutData()).widthHint = 40;
        this.autoSaveIntervalsInput.setEnabled(this.getPreferenceStore().getBoolean("autoSaveEnabled"));
        if (label2 != null) {
            Label label = new Label(parent, 0);
            label.setText(label2);
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        }
    }

    private void addAutoBackupGroup() {
        Composite parent = this.getFieldEditorParent();
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        this.autoBackupField = new BooleanFieldEditor("autoBackupEnable", WorkbenchMessages.AutoBackup_label, this.createFieldContainer(parent, true));
        this.addField((FieldEditor)this.autoBackupField);
    }

    private void addSendUsageDataGroup() {
        Composite composite = this.getFieldEditorParent();
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 5;
        composite.setLayout((Layout)gridLayout);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout2);
        this.addField((FieldEditor)new BooleanFieldEditor("usageDataUploadingEnabled", WorkbenchMessages.GeneralPrefPage_usageData_text, composite2));
        Hyperlink privacyHyperlink = new Hyperlink(composite, 0);
        privacyHyperlink.setBackground(composite.getBackground());
        privacyHyperlink.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        privacyHyperlink.setText(WorkbenchMessages.GeneralPrefPage_seePolicy_link);
        privacyHyperlink.setUnderlined(true);
        privacyHyperlink.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#77afe0")));
        privacyHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Program.launch((String)LinkUtils.getLinkByLanguage((boolean)true, (boolean)false, (String)"/privacy/usage/"));
            }
        });
        if (CathyPlugin.getDefault().isDebugging("/debug/udc/showUploadButton")) {
            Button uploadButton = new Button(composite, 8);
            GridData layoutData = new GridData(1, 0x1000000, false, false);
            layoutData.horizontalSpan = 2;
            layoutData.horizontalIndent = 10;
            layoutData.minimumWidth = 100;
            uploadButton.setLayoutData((Object)layoutData);
            uploadButton.setBackground(composite.getBackground());
            uploadButton.setText("Upload Now");
            uploadButton.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    IUsageDataSampler sampler = CathyPlugin.getDefault().getUsageDataCollector();
                    if (sampler instanceof IUsageDataUploader) {
                        ((IUsageDataUploader)sampler).forceUpload();
                    }
                }
            });
        }
    }

    private Composite createFieldContainer(Composite parent, boolean grabHorizontal) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, grabHorizontal, true));
        composite.setLayout((Layout)new GridLayout(1, false));
        return composite;
    }

    private Composite createGroup(String groupTitle) {
        Composite parent = this.getFieldEditorParent();
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(groupTitle);
        return group;
    }

    protected void initialize() {
        super.initialize();
        int startupAction = this.getPreferenceStore().getInt("startupAction2");
        this.startupActionButton.setSelection(startupAction == 3);
        this.recentFilesField.setPreferenceStore(WorkbenchPlugin.getDefault().getPreferenceStore());
        this.recentFilesField.load();
        this.autoSaveIntervalsInput.setText(String.valueOf(this.getPreferenceStore().getInt("autoSaveIntervals")));
        this.autoBackupField.setPreferenceStore(MindMapUIPlugin.getDefault().getPreferenceStore());
        this.autoBackupField.load();
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (!super.performOk()) {
            return false;
        }
        if (this.startupActionButton.getSelection()) {
            this.getPreferenceStore().setValue("startupAction2", 3);
        } else {
            this.getPreferenceStore().setValue("startupAction2", 0);
        }
        int autoSaveIntervals = NumberUtils.safeParseInt((String)this.autoSaveIntervalsInput.getText(), (int)0);
        this.getPreferenceStore().setValue("autoSaveIntervals", autoSaveIntervals);
        MindMapUIPlugin.getDefault().getPreferenceStore().setValue("autoBackupEnable", this.autoBackup);
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() instanceof FieldEditor) {
            FieldEditor fe = (FieldEditor)event.getSource();
            if (event.getProperty().equals("field_editor_value")) {
                String prefName = fe.getPreferenceName();
                if ("autoSaveEnabled".equals(prefName)) {
                    this.autoSaveIntervalsInput.setEnabled(((Boolean)event.getNewValue()).booleanValue());
                } else if ("autoBackupEnable".equals(prefName)) {
                    this.autoBackup = (Boolean)event.getNewValue();
                }
            }
        }
    }

    public void handleEvent(Event event) {
    }
}

