/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spreadsheet;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.xmind.ui.internal.spreadsheet.structures.Chart2;
import org.xmind.ui.internal.spreadsheet.structures.Row2;
import org.xmind.ui.internal.spreadsheet.structures.RowHead;
import org.xmind.ui.texteditor.FloatingTextEditorHelperBase;

public class RowHeadEditorHelper
extends FloatingTextEditorHelperBase {
    private Chart2 chart;
    private Row2 row;
    private RowHead rowHead;
    private Rectangle bounds;

    public RowHeadEditorHelper() {
    }

    public RowHeadEditorHelper(boolean extend) {
        super(extend);
    }

    public Chart2 getChart() {
        return this.chart;
    }

    public void setChart(Chart2 chart) {
        this.chart = chart;
    }

    public Row2 getRow() {
        return this.row;
    }

    public void setRow(Row2 row) {
        this.row = row;
    }

    public RowHead getRowHead() {
        return this.rowHead;
    }

    public void setRowHead(RowHead rowHead) {
        this.rowHead = rowHead;
    }

    public void activate() {
        this.bounds = null;
        super.activate();
        if (this.getEditor() != null && this.getViewer() != null && this.getRow() != null && this.getChart() != null && this.getRowHead() != null) {
            Rectangle b = this.getPreferredBounds();
            Point loc = this.getViewer().computeToControl(b.getLocation(), true);
            this.getEditor().setInitialLocation(new org.eclipse.swt.graphics.Point(loc.x, loc.y));
            this.getEditor().setInitialSize(new org.eclipse.swt.graphics.Point(b.width, b.height));
        }
    }

    public void deactivate() {
        this.bounds = null;
        super.deactivate();
    }

    protected Rectangle getPreferredBounds() {
        if (this.bounds == null) {
            this.bounds = this.calcBounds();
        }
        return this.bounds.getCopy();
    }

    private Rectangle calcBounds() {
        Dimension size = this.rowHead.getPrefSize();
        int width = this.chart.getRowHeadWidth() + this.chart.getMinorSpacing();
        int height = this.row.getHeight();
        int x = this.chart.getTitle().getTopicPart().getFigure().getBounds().x + (width - size.width) / 2;
        int y = this.row.getTop() + (height - size.height) / 2;
        return new Rectangle(x, y, size.width, size.height);
    }

    protected Font getPreferredFont() {
        return this.rowHead.getFont();
    }
}

