/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.org.freehep.graphicsio.raw;

import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import org.xmind.org.freehep.graphicsio.raw.RawImageWriteParam;
import org.xmind.org.freehep.graphicsio.raw.RawImageWriterSpi;
import org.xmind.org.freehep.util.images.ImageUtilities;

public class RawImageWriter
extends ImageWriter {
    public RawImageWriter(RawImageWriterSpi originatingProvider) {
        super(originatingProvider);
    }

    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        if (image == null) {
            throw new IllegalArgumentException("image == null");
        }
        if (image.hasRaster()) {
            throw new UnsupportedOperationException("Cannot write rasters");
        }
        Object output = this.getOutput();
        if (output == null) {
            throw new IllegalStateException("output was not set");
        }
        if (param == null) {
            param = this.getDefaultWriteParam();
        }
        ImageOutputStream ios = (ImageOutputStream)output;
        RenderedImage ri = image.getRenderedImage();
        RawImageWriteParam rawParam = (RawImageWriteParam)param;
        byte[] bytes = ImageUtilities.getBytes(ri, rawParam.getBackground(), rawParam.getCode(), rawParam.getPad());
        ios.write(bytes);
        ios.close();
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new RawImageWriteParam(this.getLocale());
    }
}

