/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editpolicies;

import java.util.ArrayList;
import java.util.List;
import org.xmind.gef.Request;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.INavigableBranchStructureExtension;
import org.xmind.ui.internal.editpolicies.MindMapTraversablePolicyBase;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.INodePart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.MindMapUtils;

public class TopicTraversablePolicy
extends MindMapTraversablePolicyBase {
    protected void findTraversables(Request request, IPart source, List<IPart> result) {
        ITopicPart topicPart = MindMapUtils.findTopicPart(source);
        if (topicPart != null) {
            IBranchPart branch = topicPart.getOwnerBranch();
            if (branch != null) {
                IStructure parentStructure;
                IBranchPart parent;
                ArrayList<IBranchPart> results = new ArrayList<IBranchPart>();
                IStructure structure = branch.getBranchPolicy().getStructure(branch);
                if (structure instanceof INavigableBranchStructureExtension) {
                    ((INavigableBranchStructureExtension)structure).calcTraversableChildren(branch, results);
                }
                if ((parent = branch.getParentBranch()) != null && (parentStructure = parent.getBranchPolicy().getStructure(parent)) instanceof INavigableBranchStructureExtension) {
                    ((INavigableBranchStructureExtension)parentStructure).calcTraversableBranches(parent, branch, results);
                }
                for (IBranchPart b : results) {
                    result.add((IPart)b.getTopicPart());
                }
            }
            if (topicPart instanceof INodePart) {
                INodePart node = (INodePart)((Object)topicPart);
                this.addTraversableResults(node.getSourceConnections(), result);
                this.addTraversableResults(node.getTargetConnections(), result);
            }
        }
    }

    protected IPart getTraverseSource(Request request) {
        ITopicPart source = MindMapUtils.findTopicPart(request.getPrimaryTarget());
        if (source != null && source.hasRole("traversable role")) {
            return source;
        }
        return null;
    }
}

