/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.decorations;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.decoration.ICorneredDecoration;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.AbstractBoundaryDecoration;

public class RoundedRectBoundaryDecoration
extends AbstractBoundaryDecoration
implements ICorneredDecoration {
    private int cornerSize = 0;

    public RoundedRectBoundaryDecoration() {
    }

    public RoundedRectBoundaryDecoration(String id) {
        super(id);
    }

    protected void sketch(IFigure figure, Path shape, Rectangle box, int purpose) {
        int c = this.getAppliedCornerSize();
        if (c == 0) {
            shape.addRectangle(box);
        } else {
            shape.addRoundedRectangle(box, (float)c);
        }
    }

    public int getCornerSize() {
        return this.cornerSize;
    }

    protected int getAppliedCornerSize() {
        return this.getCornerSize();
    }

    public void setCornerSize(IFigure figure, int cornerSize) {
        if (cornerSize == this.cornerSize) {
            return;
        }
        this.cornerSize = cornerSize;
        this.invalidate();
        if (figure != null) {
            figure.revalidate();
            figure.repaint();
        }
    }
}

