/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartListener;
import org.xmind.gef.part.IPartListener2;
import org.xmind.gef.part.PartEvent;
import org.xmind.ui.branch.IBranchHook;
import org.xmind.ui.mindmap.IBoundaryPart;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.ICacheValueProvider;
import org.xmind.ui.mindmap.IRangeListener;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.RangeEvent;
import org.xmind.ui.util.MindMapUtils;

public class FloatingMapBranchHook
implements IBranchHook,
FigureListener,
IPartListener2,
IRangeListener {
    IBranchPart branch;

    @Override
    public void hook(IBranchPart branch) {
        this.branch = branch;
        branch.getFigure().addFigureListener((FigureListener)this);
        if ("floatingBranch".equals(branch.getBranchType())) {
            branch.addPartListener((IPartListener)this);
            for (IBoundaryPart b : branch.getBoundaries()) {
                b.addRangeListener(this);
            }
            for (ISummaryPart s : branch.getSummaries()) {
                s.addRangeListener(this);
            }
        }
    }

    @Override
    public void unhook(IBranchPart branch) {
        if ("floatingBranch".equals(branch.getBranchType())) {
            for (IBoundaryPart b : branch.getBoundaries()) {
                b.removeRangeListener(this);
            }
            for (ISummaryPart s : branch.getSummaries()) {
                s.removeRangeListener(this);
            }
            branch.removePartListener((IPartListener)this);
        }
        branch.getFigure().removeFigureListener((FigureListener)this);
    }

    public void figureMoved(IFigure source) {
        if (this.needUpdate()) {
            this.branch.getBranchPolicy().flushStructureCache(this.branch, true, true);
            this.findTopBranch(this.branch, this.branch.getBranchPolicyId()).treeUpdate(false);
        }
    }

    private IBranchPart findTopBranch(IBranchPart branch, String policyId) {
        String parentId;
        IBranchPart parent = branch.getParentBranch();
        if (parent != null && policyId.equals(parentId = parent.getBranchPolicyId())) {
            return this.findTopBranch(parent, policyId);
        }
        return branch;
    }

    private boolean needUpdate() {
        String oldValue = (String)MindMapUtils.getCache((IPart)this.branch, "org.xmind.ui.branchCache.structureId");
        String newValue = this.calcStructureId(this.branch);
        if (newValue == null) {
            return false;
        }
        return !newValue.equals(oldValue);
    }

    private String calcStructureId(IBranchPart branch) {
        Object value;
        ICacheValueProvider valueProvider = MindMapUtils.getCacheManager((IPart)branch).getValueProvider("org.xmind.ui.branchCache.structureId");
        if (valueProvider != null && (value = valueProvider.getValue((IPart)branch, "org.xmind.ui.branchCache.structureId")) instanceof String) {
            return (String)value;
        }
        return null;
    }

    public void childAdding(PartEvent event) {
    }

    public void childAdded(PartEvent event) {
        if (event.child instanceof IBranchPart) {
            this.branch.getFigure().invalidate();
            this.branch.treeUpdate(true);
        } else if (event.child instanceof ISummaryPart || event.child instanceof IBoundaryPart) {
            this.branch.getFigure().invalidate();
            this.branch.treeUpdate(true);
            ((IBranchRangePart)event.child).addRangeListener(this);
        }
    }

    public void childRemoving(PartEvent event) {
    }

    public void childRemoved(PartEvent event) {
        if (event.child instanceof IBranchPart) {
            this.branch.getFigure().invalidate();
            this.branch.treeUpdate(true);
        } else if (event.child instanceof ISummaryPart || event.child instanceof IBoundaryPart) {
            this.branch.getFigure().invalidate();
            this.branch.treeUpdate(true);
            ((IBranchRangePart)event.child).removeRangeListener(this);
        }
    }

    @Override
    public void rangeChanged(RangeEvent event) {
        this.branch.getFigure().invalidate();
        this.branch.treeUpdate(true);
    }
}

