/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.xmind.core.command.ICommandService;
import org.xmind.core.usagedata.IUsageDataSampler;
import org.xmind.ui.internal.ServiceManager;
import org.xmind.ui.internal.ShareOptionRegistry;
import org.xmind.ui.internal.editor.SaveWizardManager;
import org.xmind.ui.internal.editor.WorkbookRefFactoryManager;
import org.xmind.ui.internal.statushandlers.DefaultErrorReporter;
import org.xmind.ui.internal.statushandlers.IErrorReporter;
import org.xmind.ui.mindmap.IWorkbookRefFactory;

public class MindMapUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.xmind.ui.mindmap";
    public static final String OPTION_LOCAL_FILE_BACKUP = "/debug/save/localfile/backup";
    private static MindMapUIPlugin plugin;
    private BundleContext bundleContext;
    private ServiceTracker<ICommandService, ICommandService> commandServiceTracker = null;
    private ServiceTracker<DebugOptions, DebugOptions> debugTracker = null;
    private Set<Job> jobs = new HashSet<Job>();
    private WorkbookRefFactoryManager workbookRefFactory = null;
    private SaveWizardManager saveWizardManager = null;
    private ShareOptionRegistry shareOptionRegistry = null;
    private ServiceTracker<IUsageDataSampler, IUsageDataSampler> usageDataTracker;
    private ServiceManager serviceManager = null;

    public MindMapUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.bundleContext = context;
        this.usageDataTracker = new ServiceTracker(context, IUsageDataSampler.class, null);
        this.usageDataTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.cancelAllJobs();
        if (this.commandServiceTracker != null) {
            this.commandServiceTracker.close();
            this.commandServiceTracker = null;
        }
        if (this.workbookRefFactory != null) {
            this.workbookRefFactory.dispose();
            this.workbookRefFactory = null;
        }
        if (this.saveWizardManager != null) {
            this.saveWizardManager.dispose();
            this.saveWizardManager = null;
        }
        this.usageDataTracker.close();
        this.usageDataTracker = null;
        this.bundleContext = null;
        plugin = null;
        super.stop(context);
    }

    public static void log(Throwable e, String message) {
        MindMapUIPlugin instance;
        if (message == null) {
            message = "";
        }
        if ((instance = MindMapUIPlugin.getDefault()) != null) {
            Platform.getLog((Bundle)instance.getBundle()).log((IStatus)new Status(4, PLUGIN_ID, message, e));
        } else {
            System.err.println(message);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public ICommandService getCommandService() {
        if (this.commandServiceTracker == null) {
            this.commandServiceTracker = new ServiceTracker(this.getBundle().getBundleContext(), ICommandService.class.getName(), null);
            this.commandServiceTracker.open();
        }
        return (ICommandService)this.commandServiceTracker.getService();
    }

    public IUsageDataSampler getUsageDataCollector() {
        IUsageDataSampler service = this.usageDataTracker == null ? null : (IUsageDataSampler)this.usageDataTracker.getService();
        return service == null ? IUsageDataSampler.NULL : service;
    }

    public static MindMapUIPlugin getDefault() {
        return plugin;
    }

    public IDialogSettings getDialogSettings(String sectionName) {
        IDialogSettings ds = this.getDialogSettings();
        IDialogSettings section = ds.getSection(sectionName);
        if (section == null) {
            section = ds.addNewSection(sectionName);
        }
        return section;
    }

    private DebugOptions getDebugOptions() {
        if (this.debugTracker == null) {
            this.debugTracker = new ServiceTracker(this.getBundle().getBundleContext(), DebugOptions.class, null);
            this.debugTracker.open();
        }
        return (DebugOptions)this.debugTracker.getService();
    }

    public static boolean isDebugging(String option) {
        return MindMapUIPlugin.getDefault().getDebugOptions().getBooleanOption(PLUGIN_ID + option, false);
    }

    public static <T> T getAdapter(Object obj, Class<T> adapter) {
        Object result;
        Assert.isNotNull(adapter);
        if (adapter.isInstance(obj)) {
            return adapter.cast(obj);
        }
        if (obj instanceof IAdaptable && (result = ((IAdaptable)obj).getAdapter(adapter)) != null) {
            return (T)result;
        }
        if (!(obj instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(obj, adapter)) != null) {
            return (T)result;
        }
        return null;
    }

    public void registerJob(Job job) {
        this.jobs.add(job);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                super.done(event);
                MindMapUIPlugin.this.jobs.remove(event.getJob());
            }
        });
    }

    private void cancelAllJobs() {
        Object[] runningJobs = this.jobs.toArray();
        int i = 0;
        while (i < runningJobs.length) {
            ((Job)runningJobs[i]).cancel();
            ++i;
        }
    }

    public synchronized IWorkbookRefFactory getWorkbookRefFactory() {
        if (plugin == null) {
            throw new IllegalStateException("Plugin already stopped: org.xmind.ui.mindmap");
        }
        if (this.workbookRefFactory == null) {
            this.workbookRefFactory = new WorkbookRefFactoryManager();
        }
        return this.workbookRefFactory;
    }

    public synchronized SaveWizardManager getSaveWizardManager() {
        if (plugin == null) {
            throw new IllegalStateException("Plugin already stopped: org.xmind.ui.mindmap");
        }
        if (this.saveWizardManager == null) {
            this.saveWizardManager = new SaveWizardManager();
        }
        return this.saveWizardManager;
    }

    public synchronized ShareOptionRegistry getShareOptionRegistry() {
        if (plugin == null) {
            throw new IllegalStateException("Plugin already stopped: org.xmind.ui.mindmap");
        }
        if (this.shareOptionRegistry == null) {
            this.shareOptionRegistry = new ShareOptionRegistry();
        }
        return this.shareOptionRegistry;
    }

    public Bundle findBundle(long bundleId) {
        return this.bundleContext == null ? null : this.bundleContext.getBundle(bundleId);
    }

    public IErrorReporter getErrorReporter() {
        IErrorReporter service = this.serviceManager == null ? null : this.serviceManager.getErrorReporter();
        return service == null ? DefaultErrorReporter.getInstance() : service;
    }

    void setServiceManager(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }
}

