/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.decorations;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.decoration.IShadowedDecoration;
import org.xmind.gef.draw2d.decoration.PathShapeDecoration;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.ITopicDecoration;

public abstract class AbstractTopicDecoration
extends PathShapeDecoration
implements ITopicDecoration,
IShadowedDecoration {
    private int left = 0;
    private int top = 0;
    private int right = 0;
    private int bottom = 0;

    protected AbstractTopicDecoration() {
    }

    protected AbstractTopicDecoration(String id) {
        super(id);
    }

    protected int getCheckingLineWidth() {
        return super.getCheckingLineWidth() * 2 + 4;
    }

    public void paintShadow(IFigure figure, Graphics graphics) {
        if (!this.isVisible() || !this.isFillVisible(figure)) {
            return;
        }
        this.checkValidation(figure);
        graphics.setAlpha(this.getAlpha());
        graphics.setBackgroundColor(ColorConstants.black);
        graphics.setForegroundColor(ColorConstants.black);
        this.paintFill(figure, graphics);
    }

    public Insets getPreferredInsets(IFigure figure, int width, int height) {
        return new Insets(this.getTopMargin() + this.getLineWidth(), this.getLeftMargin() + this.getLineWidth(), this.getBottomMargin() + this.getLineWidth(), this.getRightMargin() + this.getLineWidth());
    }

    @Override
    public int getLeftMargin() {
        return this.left;
    }

    @Override
    public int getTopMargin() {
        return this.top;
    }

    @Override
    public int getRightMargin() {
        return this.right;
    }

    @Override
    public int getBottomMargin() {
        return this.bottom;
    }

    @Override
    public void setLeftMargin(IFigure figure, int value) {
        if (this.left == value) {
            return;
        }
        this.left = value;
        this.invalidate();
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
    }

    @Override
    public void setTopMargin(IFigure figure, int value) {
        if (this.top == value) {
            return;
        }
        this.top = value;
        this.invalidate();
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
    }

    @Override
    public void setRightMargin(IFigure figure, int value) {
        if (this.right == value) {
            return;
        }
        this.right = value;
        this.invalidate();
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
    }

    @Override
    public void setBottomMargin(IFigure figure, int value) {
        if (this.bottom == value) {
            return;
        }
        this.bottom = value;
        this.invalidate();
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
    }

    @Override
    public Path createClippingPath(IFigure figure) {
        Path shape = new Path((Device)Display.getCurrent());
        Rectangle box = this.getOutlineBox(figure);
        this.sketch(figure, shape, box, 1);
        shape.close();
        return shape;
    }
}

