/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import java.util.List;
import org.xmind.core.ISettingEntry;
import org.xmind.core.ISheet;
import org.xmind.gef.command.ModifyCommand;
import org.xmind.ui.internal.MindMapMessages;

public class ModifySheetTabColorCommand
extends ModifyCommand {
    public ModifySheetTabColorCommand(ISheet source, String rgb) {
        super((Object)source, (Object)rgb);
        this.setLabel(MindMapMessages.ModifySheetTabColorCommand_label);
    }

    protected Object getValue(Object source) {
        if (source instanceof ISheet) {
            return this.getRgb((ISheet)source);
        }
        return null;
    }

    protected void setValue(Object source, Object value) {
        if (source instanceof ISheet && value instanceof String) {
            String oldValue = this.getRgb((ISheet)source);
            if (value.equals(oldValue)) {
                return;
            }
            this.setRgb((ISheet)source, (String)value);
        }
    }

    private String getRgb(ISheet sheet) {
        ISettingEntry entry = this.findEntry(sheet);
        return entry == null ? null : entry.getAttribute("rgb");
    }

    private void setRgb(ISheet sheet, String rgb) {
        ISettingEntry entry = this.findEntry(sheet);
        if (entry == null) {
            entry = sheet.getSettings().createEntry("tab-color");
            sheet.getSettings().addEntry(entry);
        }
        entry.setAttribute("rgb", rgb);
    }

    private ISettingEntry findEntry(ISheet sheet) {
        List entries = sheet.getSettings().getEntries("tab-color");
        return entries.size() == 0 ? null : (ISettingEntry)entries.get(0);
    }
}

