/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.net.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.xmind.core.net.Field;
import org.xmind.core.net.FieldSet;
import org.xmind.core.net.http.FormEntity;
import org.xmind.core.net.http.HttpEntity;
import org.xmind.core.net.http.HttpException;
import org.xmind.core.net.http.IFinishHandler;
import org.xmind.core.net.http.IResponseHandler;
import org.xmind.core.net.http.InvalidResponseValueException;
import org.xmind.core.net.http.StreamedEntity;
import org.xmind.core.net.internal.Activator;
import org.xmind.core.net.internal.EncodingUtils;
import org.xmind.core.net.internal.FixedLengthInputStream;
import org.xmind.core.net.internal.LoggingOutputStream;
import org.xmind.core.net.internal.MonitoredInputStream;
import org.xmind.core.net.internal.MonitoredOutputStream;
import org.xmind.core.net.internal.TeeInputStream;
import org.xmind.core.net.internal.TeeOutputStream;

public class HttpRequest {
    public static final int DEFAULT_PORT = -1;
    public static final String GET = "GET";
    public static final String POST = "POST";
    public static final String PUT = "PUT";
    public static final String DELETE = "DELETE";
    public static final int HTTP_PREPARING = 0;
    public static final int HTTP_CONNECTING = 1;
    public static final int HTTP_SENDING = 2;
    public static final int HTTP_WAITING = 3;
    public static final int HTTP_RECEIVING = 4;
    public static final int HTTP_ERROR = 999;
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOT_AUTHORITATIVE = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET = 205;
    public static final int HTTP_PARTIAL = 206;
    public static final int HTTP_MULT_CHOICE = 300;
    public static final int HTTP_MOVED_PERM = 301;
    public static final int HTTP_MOVED_TEMP = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_METHOD = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTH = 407;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECON_FAILED = 412;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_REQ_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_TYPE = 415;
    public static final int HTTP_INTERNAL_ERROR = 500;
    public static final int HTTP_NOT_IMPLEMENTED = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION = 505;
    public static final String SETTING_CONNECT_TIMEOUT = "connectTimeout";
    public static final String SETTING_READ_TIMEOUT = "readTimeout";
    private static Set<String> VALID_METHODS = new HashSet<String>(Arrays.asList("GET", "PUT", "POST", "DELETE"));
    private URL url;
    private String method;
    private FieldSet requestHeaders;
    private HttpEntity requestEntity;
    private FieldSet settings;
    private IResponseHandler responseHandler;
    private IFinishHandler finishHandler;
    private int statusCode;
    private String statusMessage;
    private FieldSet responseHeaders;
    private boolean debugging;
    private PrintStream logStream;
    private byte[] responseBuffer;
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";

    public HttpRequest(URL url, String method, FieldSet headers, HttpEntity entity, FieldSet settings, IResponseHandler responseHandler) {
        Assert.isLegal((url != null ? 1 : 0) != 0);
        Assert.isLegal((method != null && VALID_METHODS.contains(method) ? 1 : 0) != 0);
        this.url = url;
        this.method = method;
        this.requestHeaders = new FieldSet(headers);
        this.requestEntity = entity;
        this.settings = new FieldSet(settings);
        this.responseHandler = responseHandler;
        this.statusCode = 0;
        this.statusMessage = null;
        this.responseHeaders = new FieldSet();
        boolean forceDebugging = Activator.isDebugging("/debug/http/requests");
        this.debugging = forceDebugging || System.getProperty("org.xmind.debug.httprequests", null) != null;
        this.logStream = forceDebugging ? System.out : null;
        this.responseBuffer = null;
    }

    public HttpRequest(boolean https, String host, int port, String path, FieldSet queries, String ref, String method, FieldSet headers, HttpEntity entity, FieldSet settings, IResponseHandler responseHandler) {
        this(HttpRequest.makeURL(https, host, port, path, queries, ref), method, headers, entity, settings, responseHandler);
    }

    public URL getURL() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public HttpEntity getRequestEntity() {
        return this.requestEntity;
    }

    public FieldSet getRequestHeaders() {
        return new FieldSet(this.requestHeaders);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public IResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public void setFinishHandler(IFinishHandler finishHandler) {
        this.finishHandler = finishHandler;
    }

    public IFinishHandler getFinishHandler() {
        return this.finishHandler;
    }

    public byte[] getResponseBuffer() {
        return this.responseBuffer;
    }

    public String getResponseAsString() {
        if (this.responseBuffer == null) {
            return null;
        }
        return EncodingUtils.toDefaultString(this.responseBuffer);
    }

    /*
     * Loose catch block
     */
    public JSONObject getResponseAsJSON() {
        if (this.responseBuffer == null) {
            return null;
        }
        ByteArrayInputStream input = new ByteArrayInputStream(this.responseBuffer);
        JSONObject jSONObject = new JSONObject(new JSONTokener((InputStream)input));
        try {
            input.close();
        }
        catch (IOException iOException) {}
        return jSONObject;
        catch (JSONException jSONException) {
            try {}
            catch (Throwable throwable) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                input.close();
            }
            catch (IOException iOException) {}
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject getResponseAsJSONChecked() throws InvalidResponseValueException {
        JSONObject jSONObject;
        if (this.responseBuffer == null) {
            throw new InvalidResponseValueException("No response buffer.");
        }
        ByteArrayInputStream input = new ByteArrayInputStream(this.responseBuffer);
        try {
            jSONObject = new JSONObject(new JSONTokener((InputStream)input));
        }
        catch (JSONException jSONException) {
            try {
                try {
                    throw new InvalidResponseValueException(NLS.bind((String)"Illegal reponse JSON:\n{0}", (Object)new String(this.responseBuffer, "utf-8")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new InvalidResponseValueException("Illegal reponse JSON.");
                }
            }
            catch (Throwable throwable) {
                try {
                    input.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            input.close();
            return jSONObject;
        }
        catch (IOException iOException) {}
        return jSONObject;
    }

    public FieldSet getResponseHeaders() {
        return new FieldSet(this.responseHeaders);
    }

    public String getResponseHeader(String name) {
        return this.responseHeaders.getString(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(IProgressMonitor monitor) throws HttpException, InterruptedException {
        final SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (subMonitor.isCanceled()) {
            return;
        }
        final boolean[] finished = new boolean[1];
        final Throwable[] exception = new Throwable[1];
        final HttpURLConnection[] connection = new HttpURLConnection[1];
        this.log("Preparing....", new Object[0]);
        finished[0] = false;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        HttpRequest.this.doExecute((IProgressMonitor)subMonitor, connection);
                    }
                    catch (InterruptedException interruptedException) {
                        subMonitor.setCanceled(true);
                        finished[0] = true;
                    }
                    catch (Throwable e) {
                        exception[0] = e;
                        finished[0] = true;
                    }
                }
                finally {
                    finished[0] = true;
                }
            }
        }, "HttpRequestSession-" + this.method + "-" + this.url.toExternalForm());
        thread.setDaemon(true);
        thread.setPriority(3);
        thread.start();
        try {
            while (!finished[0] && !subMonitor.isCanceled()) {
                Thread.sleep(1L);
            }
        }
        finally {
            if (thread != null) {
                thread.interrupt();
            }
            if (connection[0] != null) {
                connection[0].disconnect();
            }
        }
        if (subMonitor.isCanceled()) {
            this.log("Canceled.", new Object[0]);
            throw new InterruptedException();
        }
        if (exception[0] != null) {
            Throwable e = exception[0];
            this.log("Error: {0}", e);
            if (e instanceof HttpException) {
                throw (HttpException)e;
            }
            throw new HttpException(this, e);
        }
        if (this.getStatusCode() >= 400) {
            throw new HttpException(this, null);
        }
    }

    private void doExecute(IProgressMonitor monitor, HttpURLConnection[] _connection) throws InterruptedException, IOException {
        HttpURLConnection connection;
        if (monitor.isCanceled()) {
            return;
        }
        this.log("Connecting to {0}....", this.url.getAuthority());
        this.setStatusCode(1, "Connecting");
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        _connection[0] = connection = (HttpURLConnection)this.url.openConnection();
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        this.assc(connection);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        this.log("Sending....", new Object[0]);
        this.setStatusCode(2, "Sending");
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        try {
            try {
                block25: {
                    do {
                        int readTimeout;
                        int connectTimeout;
                        if ((connectTimeout = this.settings.getInt(SETTING_CONNECT_TIMEOUT, -1)) >= 0) {
                            connection.setConnectTimeout(connectTimeout);
                        }
                        if ((readTimeout = this.settings.getInt(SETTING_READ_TIMEOUT, -1)) >= 0) {
                            connection.setReadTimeout(readTimeout);
                        }
                        connection.setInstanceFollowRedirects(false);
                        connection.setDoOutput(this.requestEntity != null);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        connection.setRequestMethod(this.method);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        this.writeHeaders(connection);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        this.writeBody(monitor, connection);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        this.log("Waiting...", new Object[0]);
                        this.setStatusCode(3, "Waiting");
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        int responseCode = connection.getResponseCode();
                        if (responseCode != 301 && responseCode != 302) break block25;
                        String newLocation = connection.getHeaderField("Location");
                        _connection[0] = connection = (HttpURLConnection)new URL(newLocation).openConnection();
                    } while (!monitor.isCanceled());
                    throw new InterruptedException();
                }
                this.readResponse(monitor, connection, connection.getInputStream(), connection.getResponseCode(), connection.getResponseMessage());
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
            catch (SocketTimeoutException e) {
                throw e;
            }
            catch (IOException e) {
                InputStream errorStream = connection.getErrorStream();
                if (errorStream == null) {
                    e.printStackTrace();
                    this.log("Error stream is NULL, response state: {0} {1}", connection.getResponseCode(), connection.getResponseMessage());
                } else {
                    this.readResponse(monitor, connection, errorStream, connection.getResponseCode(), connection.getResponseMessage());
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void setStatusCode(int newStatus, String statusMessage) {
        this.statusCode = newStatus;
        this.statusMessage = statusMessage;
    }

    private void writeHeaders(URLConnection connection) {
        ArrayList<Field> writtenHeaders = new ArrayList<Field>();
        Object userAgent = null;
        for (Field header : this.requestHeaders) {
            this.writeHeader(connection, header.name, header.getValue(), writtenHeaders);
            if (!"User-Agent".equalsIgnoreCase(header.name)) continue;
            userAgent = header.value;
        }
        if (userAgent == null || "".equals(userAgent)) {
            this.writeHeader(connection, "User-Agent", HttpRequest.getDefaultUserAgent(), writtenHeaders);
        }
        if (this.requestEntity != null) {
            this.writeHeader(connection, "Content-Type", this.requestEntity.getContentType(), writtenHeaders);
            this.writeHeader(connection, "Content-Length", String.valueOf(this.requestEntity.getContentLength()), writtenHeaders);
        }
        this.log("> {0} {1} HTTP/1.1", this.method, this.url.getPath());
        if (this.debugging) {
            for (Field header : writtenHeaders) {
                this.log("> {0}: {1}", header.name, header.value);
            }
        }
    }

    private void writeHeader(URLConnection connection, String key, String value, List<Field> headers) {
        connection.setRequestProperty(key, value);
        headers.add(new Field(key, value));
    }

    private static String getDefaultUserAgent() {
        String buildId = System.getProperty("org.xmind.product.buildid", null);
        if (buildId == null || "".equals(buildId)) {
            Activator p = Activator.getDefault();
            buildId = p != null ? p.getBundle().getVersion().toString() : "unknown";
        }
        String os = System.getProperty("osgi.os", "OS");
        String arch = System.getProperty("osgi.arch", "ARCH");
        String ws = System.getProperty("osgi.ws", "WS");
        String nl = System.getProperty("osgi.nl", "NL");
        String osName = System.getProperty("os.name", "OS_NAME");
        String osArch = System.getProperty("os.arch", "OS_ARCH");
        String osVersion = System.getProperty("os.version", "OS_VERSION");
        String javaVersion = System.getProperty("java.version", "JAVA_VERSION");
        return String.format("XMind/%s (%s.%s.%s; %s Arch/%s Version/%s; %s) Java/%s", buildId, ws, os, arch, osName, osArch, osVersion, nl, javaVersion);
    }

    private void writeBody(IProgressMonitor monitor, URLConnection connection) throws InterruptedException, IOException {
        if (this.requestEntity == null) {
            return;
        }
        OutputStream output = new MonitoredOutputStream(connection.getOutputStream(), monitor);
        if (this.debugging && this.logStream != null) {
            output = new TeeOutputStream(output, new LoggingOutputStream(this.logStream));
        }
        try {
            this.requestEntity.writeTo(output);
        }
        catch (OperationCanceledException operationCanceledException) {
            throw new InterruptedIOException();
        }
        if (this.debugging && this.logStream != null) {
            this.logStream.println();
        }
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        output.flush();
    }

    private void readResponse(IProgressMonitor monitor, URLConnection connection, InputStream readStream, int responseCode, String responseMessage) throws InterruptedException, IOException {
        if (responseCode < 0) {
            responseCode = 999;
            this.log("Unknown error, maybe not a valid HTTP response.", new Object[0]);
            this.setStatusCode(responseCode, responseMessage);
            return;
        }
        this.log("< HTTP/1.1 {0} {1}", responseCode, responseMessage);
        this.setStatusCode(responseCode, responseMessage);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        this.readResponseHeaders(connection);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        long totalBytes = this.getResponseLength(readStream);
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
        this.log("Receiving {0} bytes...", totalBytes);
        if (totalBytes >= 0L) {
            if (readStream == null) {
                throw new IOException("No input stream available to read response from");
            }
            readStream = new FixedLengthInputStream(readStream, this, totalBytes);
        }
        if (readStream != null) {
            if (this.debugging && this.logStream != null) {
                readStream = new TeeInputStream(readStream, new LoggingOutputStream(this.logStream));
            }
            ByteArrayOutputStream bufferStream = new ByteArrayOutputStream((int)totalBytes);
            readStream = new TeeInputStream(readStream, bufferStream);
            readStream = new MonitoredInputStream(readStream, monitor);
            if (this.responseHandler != null) {
                StreamedEntity responseEntity = new StreamedEntity(readStream, totalBytes);
                try {
                    this.responseHandler.handleResponseEntity(monitor, this, responseEntity);
                }
                catch (OperationCanceledException operationCanceledException) {
                    throw new InterruptedException();
                }
            }
            byte[] temp = new byte[1024];
            while (readStream.read(temp) != -1) {
            }
            this.responseBuffer = bufferStream.toByteArray();
        }
        if (this.debugging && this.logStream != null) {
            this.logStream.println();
        }
        this.log("Handled.", new Object[0]);
        if (this.finishHandler != null) {
            try {
                this.finishHandler.handleRequestFinished(monitor, this);
            }
            catch (OperationCanceledException operationCanceledException) {
                throw new InterruptedException();
            }
        }
    }

    private long getResponseLength(InputStream readStream) throws IOException {
        long totalBytes = -1L;
        String length = this.getResponseHeader("Content-Length");
        if (length != null) {
            try {
                totalBytes = Long.parseLong(length, 10);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return totalBytes;
    }

    private void readResponseHeaders(URLConnection connection) {
        String key;
        connection.getHeaderField(0);
        int i = 1;
        while ((key = connection.getHeaderFieldKey(i)) != null) {
            String value = connection.getHeaderField(i);
            this.responseHeaders.add(key, value);
            this.log("< {0}: {1}", key, value);
            ++i;
        }
    }

    public HttpRequest debug(PrintStream logStream) {
        this.debugging = true;
        this.logStream = logStream;
        return this;
    }

    private void log(String format, Object ... values) {
        if (!this.debugging) {
            return;
        }
        String prefix = format.startsWith(">") || format.startsWith("<") ? "" : "* ";
        String message = String.valueOf(prefix) + MessageFormat.format(format, values);
        if (this.logStream != null) {
            this.logStream.println(message);
        } else {
            Activator.log(message);
        }
    }

    private void assc(HttpURLConnection connection) {
        if (!Activator.isDebugging("/debug/http/assc")) {
            return;
        }
        try {
            TrustModifier.relaxHostChecking(connection);
        }
        catch (Exception e) {
            if (this.logStream != null) {
                e.printStackTrace(this.logStream);
            }
            Activator.log(e);
        }
    }

    private static URL makeURL(boolean https, String host, int port, String path, FieldSet queries, String ref) {
        URL url;
        String file;
        String protocol = https ? PROTOCOL_HTTPS : PROTOCOL_HTTP;
        String string = file = path == null ? "/" : path;
        if (queries != null) {
            file = String.valueOf(file) + "?" + new FormEntity(queries).toString();
        }
        if (ref != null) {
            file = String.valueOf(file) + "#" + ref;
        }
        try {
            url = new URL(protocol, host, port, file);
        }
        catch (MalformedURLException e) {
            throw new AssertionError("Failed creating HTTP URL from components", e);
        }
        return url;
    }

    private static class TrustModifier {
        private static final TrustingHostnameVerifier TRUSTING_HOSTNAME_VERIFIER = new TrustingHostnameVerifier();
        private static SSLSocketFactory factory;

        private TrustModifier() {
        }

        public static void relaxHostChecking(HttpURLConnection conn) throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
            if (conn instanceof HttpsURLConnection) {
                HttpsURLConnection httpsConnection = (HttpsURLConnection)conn;
                SSLSocketFactory factory = TrustModifier.prepFactory(httpsConnection);
                httpsConnection.setSSLSocketFactory(factory);
                httpsConnection.setHostnameVerifier(TRUSTING_HOSTNAME_VERIFIER);
            }
        }

        static synchronized SSLSocketFactory prepFactory(HttpsURLConnection httpsConnection) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
            if (factory == null) {
                SSLContext ctx = SSLContext.getInstance("TLS");
                ctx.init(null, new TrustManager[]{new AlwaysTrustManager()}, null);
                factory = ctx.getSocketFactory();
            }
            return factory;
        }

        private static class AlwaysTrustManager
        implements X509TrustManager {
            private AlwaysTrustManager() {
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        }

        private static final class TrustingHostnameVerifier
        implements HostnameVerifier {
            private TrustingHostnameVerifier() {
            }

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }
    }
}

