/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.tabfolder;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.services.IServiceLocator;
import org.xmind.ui.tabfolder.IPageTitleChangedListener;
import org.xmind.ui.texteditor.FloatingTextEditor;
import org.xmind.ui.texteditor.IFloatingTextEditorListener;
import org.xmind.ui.texteditor.TextEvent;

public class PageTitleEditor
extends IFloatingTextEditorListener.Stub
implements Listener {
    private CTabFolder tabFolder;
    private FloatingTextEditor editor;
    private CTabItem sourceItem;
    private List<IPageTitleChangedListener> listeners = null;
    private String contextId;
    private IServiceLocator serviceLocator;
    private IContextService cs;
    private IContextActivation ca;

    public PageTitleEditor(CTabFolder tabFolder) {
        this.tabFolder = tabFolder;
        this.editor = new FloatingTextEditor((Composite)tabFolder, 2052);
        this.hookControl(tabFolder);
        this.hookEditor(this.editor);
    }

    public String getContextId() {
        return this.contextId;
    }

    public IServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    public void setContextId(IServiceLocator serviceLocator, String contextId) {
        this.serviceLocator = serviceLocator;
        this.contextId = contextId;
    }

    public FloatingTextEditor getEditor() {
        return this.editor;
    }

    protected void hookControl(CTabFolder tabFolder) {
        tabFolder.addListener(8, (Listener)this);
    }

    protected void hookEditor(FloatingTextEditor editor) {
        editor.addFloatingTextEditorListener(this);
    }

    private void startEditing(Event e) {
        CTabItem item = this.tabFolder.getItem(new Point(e.x, e.y));
        if (item != null) {
            this.startEditing(this.tabFolder.indexOf(item));
        }
    }

    public void startEditing(int pageIndex) {
        this.startEditing(this.tabFolder.getItem(pageIndex));
    }

    private void startEditing(CTabItem item) {
        this.cancelEditing();
        this.sourceItem = item;
        if (item == null) {
            return;
        }
        Rectangle bounds = item.getBounds();
        String text = item.getText();
        this.editor.setInitialLocation(new Point(bounds.x, bounds.y));
        this.editor.setInitialSize(new Point(bounds.width, bounds.height));
        this.editor.setInput(new Document(text));
        this.editor.open();
        if (this.editor.canDoOperation(7)) {
            this.editor.doOperation(7);
        }
    }

    public void cancelEditing() {
        this.editor.close();
    }

    public void finishEditing() {
        this.editor.close(true);
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 8: {
                this.startEditing(event);
                break;
            }
            case 16: {
                if (this.editor == null || this.editor.getControl() == null || this.editor.getControl().isDisposed()) break;
                this.editor.getTextViewer().getTextWidget().removeListener(16, (Listener)this);
                this.editor.close(true);
            }
        }
    }

    public void addPageTitleChangedListener(IPageTitleChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IPageTitleChangedListener>();
        }
        this.listeners.add(listener);
    }

    public void removePageTitleChangedListener(IPageTitleChangedListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    protected void firePageTitleChanged(final int pageIndex, final String newValue) {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            final Object l = objectArray[n2];
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((IPageTitleChangedListener)l).pageTitleChanged(pageIndex, newValue);
                }
            });
            ++n2;
        }
    }

    @Override
    public void editingCanceled(TextEvent e) {
        this.deactivateContext();
        this.sourceItem = null;
    }

    @Override
    public void editingFinished(TextEvent e) {
        this.deactivateContext();
        if (this.sourceItem == null) {
            return;
        }
        int pageIndex = this.tabFolder.indexOf(this.sourceItem);
        if (pageIndex >= 0) {
            this.firePageTitleChanged(pageIndex, e.text);
        }
        this.sourceItem = null;
    }

    @Override
    public void textChanged(TextEvent e) {
        this.updateEditorBounds();
    }

    @Override
    public void editingStarted(TextEvent e) {
        super.editingStarted(e);
        this.activateContext();
        this.editor.getTextViewer().getTextWidget().addListener(16, (Listener)this);
    }

    private void activateContext() {
        if (this.getContextId() != null && this.getServiceLocator() != null) {
            this.cs = (IContextService)this.getServiceLocator().getService(IContextService.class);
            if (this.cs != null) {
                this.ca = this.cs.activateContext(this.getContextId());
            }
        }
    }

    private void deactivateContext() {
        if (this.cs != null && this.ca != null) {
            this.cs.deactivateContext(this.ca);
        }
        this.cs = null;
        this.ca = null;
    }

    private void updateEditorBounds() {
    }
}

