/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.richtext;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.ExternalActionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolItem;

public class BulletActionGroup
extends ContributionItem {
    private List<IAction> actions = new ArrayList<IAction>();
    private IAction currentAction = null;
    private IPropertyChangeListener actionListener = null;
    private ToolItem widget = null;
    private IPropertyChangeListener currentActionListener = null;
    private LocalResourceManager imageManager;

    public void add(IAction action) {
        this.actions.add(action);
        action.addPropertyChangeListener(this.getActionListener());
        if (this.currentAction == null) {
            this.setCurrentAction(action);
        }
    }

    public void remove(IAction action) {
        action.removePropertyChangeListener(this.getActionListener());
        this.actions.remove(action);
        if (this.currentAction == action) {
            this.setCurrentAction(this.actions.isEmpty() ? null : this.actions.get(0));
        }
    }

    public IAction getCurrentAction() {
        return this.currentAction;
    }

    private void setCurrentAction(IAction action) {
        if (this.currentAction != null && this.currentActionListener != null) {
            this.currentAction.removePropertyChangeListener(this.currentActionListener);
        }
        this.currentAction = action;
        if (action != null) {
            action.setChecked(true);
        }
        for (IAction a : this.actions) {
            if (a == action) continue;
            a.setChecked(false);
        }
        if (action != null && this.widget != null && !this.widget.isDisposed()) {
            action.addPropertyChangeListener(this.getCurrentActionListener());
        }
        this.update(null);
    }

    private IPropertyChangeListener getActionListener() {
        if (this.actionListener == null) {
            this.actionListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    BulletActionGroup.this.actionPropertyChange(event);
                }
            };
        }
        return this.actionListener;
    }

    private void actionPropertyChange(PropertyChangeEvent event) {
        IAction trigerAction = (IAction)event.getSource();
        String property = event.getProperty();
        if ("checked".equals(property) && Boolean.TRUE.equals(event.getNewValue())) {
            this.setCurrentAction(trigerAction);
        }
    }

    private IPropertyChangeListener getCurrentActionListener() {
        if (this.currentActionListener == null) {
            this.currentActionListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    BulletActionGroup.this.currentActionPropertyChange(event);
                }
            };
        }
        return this.currentActionListener;
    }

    private void currentActionPropertyChange(final PropertyChangeEvent event) {
        if (this.isVisible() && this.widget != null) {
            Display display = this.widget.getDisplay();
            if (display.getThread() == Thread.currentThread()) {
                this.update(event.getProperty());
            } else {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BulletActionGroup.this.update(event.getProperty());
                    }
                });
            }
        }
    }

    public void update() {
        this.update(null);
    }

    public void update(String propertyName) {
        boolean showText;
        if (this.widget == null || this.currentAction == null) {
            return;
        }
        boolean textChanged = propertyName == null || propertyName.equals("text");
        boolean imageChanged = propertyName == null || propertyName.equals("image");
        boolean tooltipTextChanged = propertyName == null || propertyName.equals("toolTipText");
        boolean enableStateChanged = propertyName == null || propertyName.equals("enabled") || propertyName.equals("enabled");
        boolean checkChanged = !(this.currentAction.getStyle() != 2 && this.currentAction.getStyle() != 8 || propertyName != null && !propertyName.equals("checked"));
        ToolItem ti = this.widget;
        String text = this.currentAction.getText();
        boolean bl = showText = text != null && !this.hasImages(this.currentAction);
        if (showText && text != null) {
            text = Action.removeAcceleratorText((String)text);
            text = Action.removeMnemonics((String)text);
        }
        if (textChanged) {
            boolean rightStyle;
            String textToSet = showText ? text : "";
            boolean bl2 = rightStyle = (ti.getParent().getStyle() & 0x20000) != 0;
            if (rightStyle || !ti.getText().equals(textToSet)) {
                ti.setText(textToSet);
            }
        }
        if (imageChanged) {
            this.updateImages(!showText);
        }
        if (tooltipTextChanged || textChanged) {
            String acceleratorText;
            String toolTip = this.currentAction.getToolTipText();
            if (toolTip == null || toolTip.length() == 0) {
                toolTip = text;
            }
            ExternalActionManager.ICallback callback = ExternalActionManager.getInstance().getCallback();
            String commandId = this.currentAction.getActionDefinitionId();
            if (callback != null && commandId != null && toolTip != null && (acceleratorText = callback.getAcceleratorText(commandId)) != null && acceleratorText.length() != 0) {
                toolTip = JFaceResources.format((String)"Toolbar_Tooltip_Accelerator", (Object[])new Object[]{toolTip, acceleratorText});
            }
            if (!showText || toolTip != null && !toolTip.equals(text)) {
                ti.setToolTipText(toolTip);
            } else {
                ti.setToolTipText(null);
            }
        }
        if (enableStateChanged) {
            boolean shouldBeEnabled;
            boolean bl3 = shouldBeEnabled = this.currentAction.isEnabled() && this.isEnabledAllowed();
            if (ti.getEnabled() != shouldBeEnabled) {
                ti.setEnabled(shouldBeEnabled);
            }
        }
        if (checkChanged) {
            boolean bv = this.currentAction.isChecked();
            if (ti.getSelection() != bv) {
                ti.setSelection(bv);
            }
        }
    }

    private boolean hasImages(IAction actionToCheck) {
        return actionToCheck.getImageDescriptor() != null || actionToCheck.getHoverImageDescriptor() != null || actionToCheck.getDisabledImageDescriptor() != null;
    }

    private boolean updateImages(boolean forceImage) {
        ResourceManager parentResourceManager = JFaceResources.getResources();
        ImageDescriptor image = this.currentAction.getHoverImageDescriptor();
        if (image == null) {
            image = this.currentAction.getImageDescriptor();
        }
        ImageDescriptor disabledImage = this.currentAction.getDisabledImageDescriptor();
        if (image == null && forceImage) {
            image = ImageDescriptor.getMissingImageDescriptor();
        }
        LocalResourceManager localManager = new LocalResourceManager(parentResourceManager);
        this.widget.setDisabledImage(disabledImage == null ? null : localManager.createImageWithDefault(disabledImage));
        this.widget.setImage(image == null ? null : localManager.createImageWithDefault(image));
        this.disposeOldImages();
        this.imageManager = localManager;
        return image != null;
    }

    private void disposeOldImages() {
        if (this.imageManager != null) {
            this.imageManager.dispose();
            this.imageManager = null;
        }
    }

    private boolean isEnabledAllowed() {
        if (this.getParent() == null) {
            return true;
        }
        Boolean value = this.getParent().getOverrides().getEnabled((IContributionItem)this);
        return value == null ? true : value;
    }
}

