/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.properties;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.xmind.ui.properties.PropertyEditor;

public class TextPropertyEditor
extends PropertyEditor {
    private static final int DEFAULT_STYLE = 2052;
    private int style;
    private Text text;
    private boolean modifying = false;
    private boolean regardEmptyStringAsNull;

    public TextPropertyEditor() {
        this(2052, false);
    }

    public TextPropertyEditor(boolean regardEmptyStringAsNull) {
        this(2052, regardEmptyStringAsNull);
    }

    public TextPropertyEditor(int style) {
        this(style, false);
    }

    public TextPropertyEditor(int style, boolean regardEmptyStringAsNull) {
        this.style = style;
        this.regardEmptyStringAsNull = regardEmptyStringAsNull;
    }

    @Override
    protected Control createControl(Composite parent) {
        this.text = new Text(parent, this.style);
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                TextPropertyEditor.this.fireApplyEditorValue();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    TextPropertyEditor.this.fireCancelEditing();
                    e.doit = false;
                } else if (e.detail == 4) {
                    TextPropertyEditor.this.fireApplyEditorValue();
                    e.doit = false;
                }
            }
        });
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (e.keyCode == 27 && e.stateMask == 0) {
                    TextPropertyEditor.this.fireCancelEditing();
                    e.doit = false;
                } else if (e.keyCode == 13) {
                    TextPropertyEditor.this.fireApplyEditorValue();
                    e.doit = false;
                }
            }
        });
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (TextPropertyEditor.this.modifying) {
                    return;
                }
                String value = TextPropertyEditor.this.text.getText();
                if (TextPropertyEditor.this.regardEmptyStringAsNull && "".equals(value)) {
                    value = null;
                }
                TextPropertyEditor.this.changeValue(value);
            }
        });
        this.text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    TextPropertyEditor.this.fireApplyEditorValue();
                    e.doit = false;
                }
            }
        });
        return this.text;
    }

    @Override
    protected void setValueToWidget(Object value) {
        if (this.text == null || this.text.isDisposed()) {
            return;
        }
        this.modifying = true;
        try {
            String content = value == null ? "" : value.toString();
            this.text.setText(content);
        }
        finally {
            this.modifying = false;
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.text.setFont(font);
    }
}

