/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.ideafactory;

import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.gef.command.SourceCommand;
import org.xmind.ui.internal.ideafactory.IdeaFactoryMessages;

public class ModifyIdeaFontSizeCommand
extends SourceCommand {
    private ITopic rootTopic;
    private String fontSize;
    private ITopicExtensionElement fontSizeElement;
    private String oldFontSize;

    public ModifyIdeaFontSizeCommand(ITopic rootTopic, int fontSize) {
        super((Object)rootTopic);
        this.rootTopic = rootTopic;
        this.fontSize = "" + fontSize;
        this.setLabel(IdeaFactoryMessages.ModifyIdeaFontSizeCommand_Modify_Idea_Font);
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        if (this.fontSizeElement == null) {
            ITopicExtension ext = this.rootTopic.createExtension("org.xmind.ui.ideafactory");
            ITopicExtensionElement content = ext.getContent();
            this.fontSizeElement = (ITopicExtensionElement)content.getCreatedChild("font-size");
        }
        if (this.oldFontSize == null) {
            String size = this.fontSizeElement.getTextContent();
            this.oldFontSize = size == null ? "" : size;
        }
        this.fontSizeElement.setTextContent(this.fontSize);
        this.fireCoreEvent(this.rootTopic, "fontSize");
        super.redo();
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        if (this.oldFontSize != null) {
            this.fontSizeElement.setTextContent(this.oldFontSize);
            this.fireCoreEvent(this.rootTopic, "fontSize");
        }
        super.undo();
    }

    private void fireCoreEvent(ITopic topic, String eventType) {
        if (topic instanceof ICoreEventSource) {
            ((ICoreEventSource)topic).getCoreEventSupport().dispatchTargetChange((ICoreEventSource)topic, eventType, (Object)this.fontSizeElement);
        }
    }
}

