/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.gallery;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.core.internal.gallery.DownloadedGalleryItem;
import org.xmind.core.internal.gallery.GallerySheet;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.internal.gallery.IGalleryItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadedGalleryGroup
implements IGalleryGroup {
    private Element implementation;
    private GallerySheet ownedSheet;

    DownloadedGalleryGroup(Element implementation, GallerySheet ownedSheet) {
        this.implementation = implementation;
        this.ownedSheet = ownedSheet;
    }

    protected Element getImplementation() {
        return this.implementation;
    }

    public GallerySheet getOwnedSheet() {
        return this.ownedSheet;
    }

    public GallerySheet getParent() {
        return this.ownedSheet;
    }

    @Override
    public String getSymbolicName() {
        return this.getImplementation().getAttribute("name");
    }

    @Override
    public String getName() {
        String displayName = this.getImplementation().getAttribute("display-name");
        if (displayName == null || "".equals(displayName)) {
            return this.getSymbolicName();
        }
        return displayName;
    }

    @Override
    public List<IGalleryItem> getItems() {
        ArrayList<IGalleryItem> galleryItems = new ArrayList<IGalleryItem>();
        NodeList childNodes = this.getImplementation().getChildNodes();
        int index = 0;
        while (index < childNodes.getLength()) {
            if (childNodes.item(index) instanceof Element) {
                DownloadedGalleryItem galleryItem = new DownloadedGalleryItem((Element)childNodes.item(index), this.ownedSheet);
                galleryItems.add(galleryItem);
            }
            ++index;
        }
        return galleryItems;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof DownloadedGalleryGroup)) {
            return false;
        }
        DownloadedGalleryGroup that = (DownloadedGalleryGroup)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public boolean moveItemAfter(IGalleryItem item, IGalleryItem lastItem) {
        Node lastParent;
        if (!(item instanceof DownloadedGalleryItem) || lastItem != null && !(lastItem instanceof DownloadedGalleryItem)) {
            throw new IllegalArgumentException("Not a DownloadedGalleryItem.");
        }
        DownloadedGalleryItem theItem = (DownloadedGalleryItem)item;
        DownloadedGalleryItem theLastItem = (DownloadedGalleryItem)lastItem;
        if (theItem.getOwnedSheet() != this.getOwnedSheet() || theLastItem != null && theLastItem.getOwnedSheet() != this.getOwnedSheet()) {
            throw new IllegalArgumentException("Can not move gallery item that is not owned by the gallery sheet.");
        }
        Element itemEle = theItem.getImplementation();
        Element lastItemEle = theLastItem == null ? null : theLastItem.getImplementation();
        Node node = lastParent = lastItemEle == null ? null : lastItemEle.getParentNode();
        if (lastItemEle != null && lastParent != this.implementation) {
            throw new IllegalArgumentException("The last gallery item has invalid parent.");
        }
        Node oldPrev = itemEle.getPreviousSibling();
        Node oldNext = itemEle.getNextSibling();
        Node oldParent = itemEle.getParentNode();
        if (oldParent != null) {
            oldParent.removeChild(itemEle);
        }
        if (lastItem == null) {
            this.implementation.insertBefore(itemEle, this.implementation.getFirstChild());
        } else {
            this.implementation.insertBefore(itemEle, lastItemEle.getNextSibling());
        }
        return oldPrev != itemEle.getPreviousSibling() || oldNext != itemEle.getNextSibling() || oldParent != itemEle.getParentNode();
    }

    public void removeItem(IGalleryItem item) {
        if (!(item instanceof DownloadedGalleryItem)) {
            throw new IllegalArgumentException("Not a DownloadedGalleryItem.");
        }
        DownloadedGalleryItem theItem = (DownloadedGalleryItem)item;
        if (theItem.getOwnedSheet() != this.getOwnedSheet()) {
            throw new IllegalArgumentException("Can not remove gallery item that is not owned by the gallery sheet.");
        }
        Element groupEle = theItem.getImplementation();
        if (groupEle.getParentNode() != this.implementation) {
            throw new IllegalArgumentException("The gallery item has invalid parent.");
        }
        String path = theItem.getPath();
        if (path != null && !"".equals(path)) {
            new File(path).delete();
        }
        this.implementation.removeChild(groupEle);
    }
}

