/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.ArrayList;
import java.util.Collection;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.AbstractRefCounter;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.util.ILabelRefCounter;

public class SheetLabelRefCounter
extends AbstractRefCounter
implements ILabelRefCounter,
ICoreEventSource {
    private SheetImpl ownedSheet;
    private Collection<String> oldValue = null;

    public SheetLabelRefCounter(SheetImpl ownedSheet) {
        this.ownedSheet = ownedSheet;
    }

    protected Object findResource(String resourceId) {
        return this;
    }

    public void increaseRef(String resourceId) {
        this.oldValue = new ArrayList<String>(this.getCountedRefs());
        super.increaseRef(resourceId);
    }

    protected void postIncreaseRef(String resourceId, Object resource) {
        if (this.oldValue != null) {
            Collection<String> oldValue = this.oldValue;
            ArrayList<String> newValue = new ArrayList<String>(this.getCountedRefs());
            this.oldValue = null;
            this.fireValueChange("resourceRefs", oldValue, newValue);
        }
    }

    public void decreaseRef(String resourceId) {
        this.oldValue = new ArrayList<String>(this.getCountedRefs());
        super.decreaseRef(resourceId);
    }

    protected void postDecreaseRef(String resourceId, Object resource) {
        if (this.oldValue != null) {
            Collection<String> oldValue = this.oldValue;
            ArrayList<String> newValue = new ArrayList<String>(this.getCountedRefs());
            this.oldValue = null;
            this.fireValueChange("resourceRefs", oldValue, newValue);
        }
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.ownedSheet.getCoreEventSupport();
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    private void fireValueChange(String eventType, Object oldValue, Object newValue) {
        this.getCoreEventSupport().dispatchValueChange(this, eventType, oldValue, newValue);
    }
}

