/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.exports.vector.svg;

import java.awt.Graphics2D;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.de.erichseifert.vectorgraphics2d.SVGGraphics2D;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.util.Properties;
import org.xmind.ui.exports.vector.graphics.GraphicsToGraphics2DAdaptor;
import org.xmind.ui.internal.figures.SheetFigure;
import org.xmind.ui.mindmap.GhostShellProvider;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapExportViewer;
import org.xmind.ui.viewers.ICompositeProvider;
import org.xmind.ui.wizards.Exporter;
import org.xmind.ui.wizards.IExportPart;

public class SVGExporter
extends Exporter {
    private static final int DEFAULT_MARGIN = 15;
    private ISheet sheet;
    private String targetPath;
    private IGraphicalViewer viewer;
    private IGraphicalViewer exportViewer;
    private ICompositeProvider compositeProvider;
    private Rectangle bounds;
    private SVGGraphics2D svgGenerator;
    private GraphicsToGraphics2DAdaptor adaptor;
    private IDialogSettings settings;

    public SVGExporter(ISheet sheet, ITopic centralTopic, String targetPath, IGraphicalViewer viewer, IDialogSettings settings) {
        super(sheet, centralTopic);
        this.sheet = sheet;
        this.targetPath = targetPath;
        this.viewer = viewer;
        this.settings = settings;
    }

    public void init() {
        this.bounds = this.getFigureBounds();
        this.svgGenerator = new SVGGraphics2D(0.0, 0.0, (double)this.bounds.width, (double)this.bounds.height);
    }

    private Rectangle getFigureBounds() {
        Rectangle extent = this.getSheetFigure().getFreeformExtent();
        return new Rectangle(0, 0, extent.width + 30, extent.height + 30);
    }

    public void start(Display display, Shell shell) throws InvocationTargetException {
        super.start(display, shell);
        this.adaptor = new GraphicsToGraphics2DAdaptor((Graphics2D)this.svgGenerator, this.bounds, display);
        this.setTranslate(this.adaptor);
        this.compositeProvider = new GhostShellProvider(display);
        display.syncExec(new Runnable(){

            public void run() {
                SVGExporter.this.exportViewer = (IGraphicalViewer)new MindMapExportViewer(SVGExporter.this.compositeProvider, SVGExporter.this.viewer.getAdapter(IMindMap.class), SVGExporter.this.viewer.getProperties());
                Properties properties = SVGExporter.this.exportViewer.getProperties();
                SVGExporter.this.initProperties(properties);
                SVGExporter.this.exportViewer.getCanvas().getLightweightSystem().getUpdateManager().performValidation();
                SVGExporter.this.exportViewer.getLayer(GEF.LAYER_BACKGROUND).paint((Graphics)SVGExporter.this.adaptor);
                SVGExporter.this.exportViewer.getLayer(GEF.LAYER_CONTENTS).paint((Graphics)SVGExporter.this.adaptor);
            }
        });
    }

    protected void initProperties(Properties properties) {
        boolean plusVisible = this.getBoolean(this.settings, "plusVisible", true);
        boolean minusVisible = this.getBoolean(this.settings, "minusVisible", true);
        properties.set("plusVisible", plusVisible);
        properties.set("minusVisible", minusVisible);
        if ("linux".equals(Platform.getOS())) {
            properties.set("renderTextAsPath", false);
        } else {
            properties.set("renderTextAsPath", true);
        }
    }

    private boolean getBoolean(IDialogSettings settings, String key, boolean defaultValue) {
        boolean value = defaultValue;
        if (settings.get(key) != null) {
            value = settings.getBoolean(key);
        }
        return value;
    }

    protected void write(IProgressMonitor monitor, IExportPart part) throws InvocationTargetException, InterruptedException {
    }

    public void end() throws InvocationTargetException {
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.targetPath), "UTF-8");
            out.write(this.svgGenerator.toString());
            ((Writer)out).close();
            this.adaptor.dispose();
            this.cleanUpSources();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    private void cleanUpSources() {
        if (this.exportViewer != null) {
            if (this.exportViewer.getControl() != null) {
                this.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        SVGExporter.this.exportViewer.getControl().dispose();
                    }
                });
            }
            this.exportViewer = null;
        }
        if (this.compositeProvider instanceof GhostShellProvider) {
            this.getDisplay().syncExec(new Runnable(){

                public void run() {
                    ((GhostShellProvider)SVGExporter.this.compositeProvider).dispose();
                }
            });
            this.compositeProvider = null;
        }
    }

    public boolean canStart() {
        return true;
    }

    private SheetFigure getSheetFigure() {
        return (SheetFigure)this.viewer.findGraphicalPart((Object)this.sheet).getContentPane();
    }

    private void setTranslate(GraphicsToGraphics2DAdaptor graphicsAdaptor) {
        Rectangle extent = this.getSheetFigure().getFreeformExtent();
        int translateX = 15 - extent.x;
        int translateY = 15 - extent.y;
        graphicsAdaptor.translate(translateX, translateY);
    }
}

