/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.tool;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.xmind.gef.Request;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.GraphicalTool;
import org.xmind.gef.tool.ISourceTool;
import org.xmind.gef.tool.ITool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EditTool
extends GraphicalTool
implements ISourceTool {
    private IGraphicalEditPart source;
    private boolean remainActive = false;
    private Set<String> editRequestTypes = new HashSet<String>();
    private Request lastForwardedRequest = null;

    @Override
    public IGraphicalEditPart getSource() {
        return this.source;
    }

    @Override
    public void setSource(IGraphicalEditPart source) {
        this.source = source;
    }

    @Override
    protected void onActivated(ITool prevTool) {
        super.onActivated(prevTool);
        this.refreshStatus();
    }

    @Override
    protected void onDeactivated(ITool nextTool) {
        this.finishEditing();
        super.onDeactivated(nextTool);
    }

    protected void refreshStatus() {
        this.getStatus().setStatus(4, false);
        this.getStatus().setStatus(8, false);
        this.getStatus().setStatus(2, false);
    }

    protected void handleEditRequest(Request request) {
        IPart target = request.getPrimaryTarget();
        if (target instanceof IGraphicalEditPart) {
            IGraphicalEditPart newSource = (IGraphicalEditPart)target;
            if (this.canEdit(newSource)) {
                if (newSource != this.getSource()) {
                    this.remainActive = true;
                    this.finishEditing();
                    this.remainActive = false;
                }
                this.setSource(newSource);
                if (this.acceptEditRequest(request)) {
                    if (this.shouldUpdateSelectionOnEdit(newSource, request)) {
                        this.getTargetViewer().setSelection((ISelection)new StructuredSelection((Object)newSource), true);
                    }
                    if (!this.startEditing(this.getSource())) {
                        this.changeActiveTool("default tool");
                    }
                } else {
                    this.finishEditing();
                }
            } else {
                this.finishEditing();
                if (request != this.lastForwardedRequest) {
                    this.lastForwardedRequest = request;
                    this.getDomain().handleRequest(request);
                }
            }
        }
    }

    protected boolean shouldUpdateSelectionOnEdit(IGraphicalEditPart newSource, Request request) {
        return true;
    }

    protected boolean canEdit(IGraphicalEditPart target) {
        return true;
    }

    protected boolean acceptEditRequest(Request request) {
        return true;
    }

    protected boolean startEditing(IGraphicalEditPart source) {
        return false;
    }

    protected void cancelEditing() {
        if (!this.remainActive) {
            this.changeActiveTool("default tool");
        }
    }

    protected void finishEditing() {
        if (!this.remainActive) {
            this.changeActiveTool("default tool");
        }
    }

    protected boolean isViewRequest(String reqType) {
        String role = this.getDomain().getPartRoles().getRole(reqType);
        return this.isViewRole(role);
    }

    protected boolean isViewRole(String role) {
        return "selectable role".equals(role) || "scalable role".equals(role) || "modifiable role".equals(role);
    }

    protected Collection<String> getEditRequestTypes() {
        return this.editRequestTypes;
    }

    protected void addEditRequestType(String reqType) {
        this.editRequestTypes.add(reqType);
    }

    protected void removeEditRequestType(String reqType) {
        this.editRequestTypes.remove(reqType);
    }

    @Override
    protected void internalHandleRequest(Request request) {
        if (request.getTargetViewer() == null || request.getTargetViewer() != this.getTargetViewer()) {
            super.internalHandleRequest(request);
            return;
        }
        String requestType = request.getType();
        if ("edit".equals(requestType) || this.getEditRequestTypes().contains(requestType)) {
            this.handleEditRequest(request);
        } else if ("select_all".equals(requestType)) {
            this.selectAll();
        } else if ("copy".equals(requestType)) {
            this.copy();
        } else if ("cut".equals(requestType)) {
            this.cut();
        } else if ("paste".equals(requestType)) {
            this.paste();
        } else if ("delete".equals(requestType)) {
            this.delete();
        } else if ("cancel".equals(requestType)) {
            this.cancelEditing();
        } else if ("finish".equals(requestType)) {
            this.finishEditing();
        } else if ("redo".equals(requestType)) {
            if (this.canRedo()) {
                this.redo();
            }
        } else if ("undo".equals(requestType)) {
            if (this.canUndo()) {
                this.undo();
            }
        } else if (this.isViewRequest(requestType)) {
            this.getDomain().getDefaultTool().handleRequest(request);
        } else {
            this.finishEditing();
            if (!this.getStatus().isStatus(1)) {
                this.getDomain().handleRequest(request);
            } else {
                this.getDomain().getDefaultTool().handleRequest(request);
            }
        }
    }

    protected void selectAll() {
    }

    protected void copy() {
    }

    protected void cut() {
    }

    protected void paste() {
    }

    protected void delete() {
    }

    protected void undo() {
    }

    protected void redo() {
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }

    @Override
    protected boolean handleMouseDown(MouseEvent me) {
        if (this.shouldFinishOnMouseDown(me)) {
            this.finishEditing();
            ITool activeTool = this.getDomain().getActiveTool();
            if (activeTool != this) {
                activeTool.mouseDown(me, this.getTargetViewer());
            }
            return true;
        }
        return super.handleMouseDown(me);
    }

    protected boolean shouldFinishOnMouseDown(MouseEvent me) {
        return me.target != this.getSource();
    }

    @Override
    protected boolean handleKeyUp(KeyEvent ke) {
        if (this.shouldFinish(ke)) {
            this.finishEditing();
            return true;
        }
        if (this.shouldCancel(ke)) {
            this.cancelEditing();
            return true;
        }
        return super.handleKeyUp(ke);
    }

    protected abstract boolean shouldCancel(KeyEvent var1);

    protected abstract boolean shouldFinish(KeyEvent var1);

    @Override
    protected boolean handleMouseEntered(MouseEvent me) {
        if (me.target.hasRole("selectable role")) {
            this.getTargetViewer().setPreselected(me.target);
        }
        return super.handleMouseEntered(me);
    }
}

