/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.tool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRootPart;
import org.xmind.gef.tool.AreaCreateTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AreaSelectTool
extends AreaCreateTool {
    private List<IPart> lastSelected = null;
    private List<IPart> newSelected = null;

    @Override
    protected void start() {
        super.start();
        this.lastSelected = this.getStatus().isStatus(4) ? new ArrayList<IPart>(this.getSelectedParts(this.getTargetViewer())) : new ArrayList<IPart>();
        this.newSelected = new ArrayList<IPart>();
        this.getTargetViewer().setFocused(null);
    }

    @Override
    protected void end() {
        this.lastSelected = null;
        this.newSelected = null;
    }

    @Override
    protected void updateArea(Rectangle area, Point currentPos) {
        super.updateArea(area, currentPos);
        IRootPart rootPart = this.getTargetViewer().getRootPart();
        this.areaSelect(rootPart, area);
        List<IPart> selection = this.getMergedSelection();
        this.updateSelectionStatus(rootPart, selection);
        IPart toFocus = selection.isEmpty() ? null : selection.get(selection.size() - 1);
        this.getTargetViewer().setFocused(toFocus);
    }

    protected void updateSelectionStatus(IPart part, List<IPart> selection) {
        if (selection.contains(part)) {
            part.getStatus().select();
        } else {
            part.getStatus().deSelect();
        }
        for (IPart child : part.getChildren()) {
            this.updateSelectionStatus(child, selection);
        }
    }

    protected void areaSelect(IPart part, Rectangle area) {
        this.select(part, area);
        for (IPart child : part.getChildren()) {
            this.areaSelect(child, area);
        }
    }

    protected void select(IPart part, Rectangle area) {
        if (this.isSelectable(part, area)) {
            if (!this.newSelected.contains(part)) {
                this.newSelected.add(part);
            }
        } else {
            this.newSelected.remove(part);
        }
    }

    protected boolean isSelectable(IPart part, Rectangle area) {
        if (this.getTargetViewer().getSelectionSupport().isSelectable(part) && part instanceof IGraphicalPart) {
            IGraphicalPart gp = (IGraphicalPart)part;
            return area.intersects(gp.getFigure().getBounds());
        }
        return false;
    }

    protected List<IPart> getMergedSelection() {
        HashSet<IPart> inter = new HashSet<IPart>(this.newSelected);
        inter.retainAll(this.lastSelected);
        ArrayList<IPart> selection = new ArrayList<IPart>(this.lastSelected);
        selection.addAll(this.newSelected);
        selection.removeAll(inter);
        return selection;
    }

    @Override
    public void finish() {
        this.applySelection();
        super.finish();
    }

    protected void applySelection() {
        this.getTargetViewer().setSelection((ISelection)new StructuredSelection(this.getMergedSelection()), true);
    }

    @Override
    public void cancel() {
        this.revertSelection();
        super.cancel();
    }

    protected void revertSelection() {
        this.getTargetViewer().getSelectionSupport().refresh();
    }
}

