/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.audionotes;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xmind.core.IResourceRef;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.audio.AudioValues;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.audionotes.AudioNotesAgent;
import org.xmind.ui.internal.audionotes.AudioNotesPlugin;
import org.xmind.ui.internal.audionotes.AudioNotesPropertiesDialog;
import org.xmind.ui.internal.audionotes.AudioNotesUtils;
import org.xmind.ui.internal.audionotes.DeleteAudioNotesCommand;
import org.xmind.ui.internal.audionotes.IAudioNotesAgentListener;
import org.xmind.ui.internal.audionotes.Messages;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.mindmap.AbstractInfoItemContributor;
import org.xmind.ui.mindmap.ICacheManager;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.MindMapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioNotesInfoItemContributor
extends AbstractInfoItemContributor {
    private static final String CACHE_AUDIO_LISTENER = "org.xmind.ui.audionotes.cache.audioListener";

    private static boolean stopRecord(ITopic topic) {
        AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
        if (agent.isRecording() && topic.equals(agent.getCurrentTopic())) {
            agent.stop();
            return false;
        }
        return true;
    }

    public IAction createAction(ITopicPart topicPart, ITopic topic) {
        ITopicExtension ext = topic.getExtension("org.xmind.ui.audionotes");
        Action action = null;
        if (ext != null) {
            List resRefs;
            String recording = ext.getContent().getAttribute("recording");
            if (recording != null) {
                action = new StopRecordingAction(topic);
            }
            if (!(resRefs = ext.getResourceRefs()).isEmpty()) {
                AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
                if (agent.isPlaying() && topic.equals(agent.getCurrentTopic())) {
                    action = new StopPlayingAction(topic);
                } else {
                    action = new StartPlayingAction(topic);
                    action.setToolTipText(this.getContent(topic));
                }
            }
        }
        return action;
    }

    public String getContent(ITopic topic) {
        String fileSize;
        ITopicExtension ext = topic.getExtension("org.xmind.ui.audionotes");
        ITopicExtensionElement content = ext.getContent();
        List audioElements = content.getChildren("record-time");
        String shortTime = audioElements != null && !audioElements.isEmpty() && ((ITopicExtensionElement)audioElements.get(0)).getTextContent().contains(", ") ? ((ITopicExtensionElement)audioElements.get(0)).getTextContent().split(", ")[1] : String.format("%1$tb %1$td %1$tY", new Date().getTime());
        StringBuilder contentBuilder = new StringBuilder();
        contentBuilder.append(shortTime).append(' ');
        String duration = AudioNotesUtils.formatTime(AudioNotesUtils.getDuration(topic));
        if (duration != null) {
            contentBuilder.append(duration);
        }
        if ((fileSize = AudioNotesUtils.formatFileSize(AudioNotesUtils.getFileSize(topic))) != null) {
            contentBuilder.append(' ').append('/').append(' ').append(fileSize);
        }
        return contentBuilder.toString();
    }

    public String getSVGFilePath(ITopic topic, IAction action) {
        AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
        return "platform:/plugin/org.xmind.ui.audionotes/icons/" + (agent.isPlaying() ? "audio_stop.svg" : "audio_play.svg");
    }

    public boolean isCardModeAvailable(ITopic topic, ITopicPart topicPart) {
        return !this.isIconTipOnly(topicPart);
    }

    protected void registerTopicEvent(ITopicPart topicPart, ITopic topic, ICoreEventRegister register) {
        register.register("org.xmind.core.event.audioNotesRecorded");
        register.register("org.xmind.core.event.audioNotesModify");
    }

    protected void handleTopicEvent(IInfoPart infoPart, CoreEvent event) {
    }

    protected void handleTopicEvent(ITopicPart topicPart, CoreEvent event) {
        String type = event.getType();
        if ("org.xmind.core.event.audioNotesRecorded".equals(type)) {
            topicPart.refresh();
        }
        if ("org.xmind.core.event.audioNotesModify".equals(type)) {
            topicPart.refresh();
        }
    }

    public void topicActivated(final ITopicPart topicPart) {
        super.topicActivated(topicPart);
        ICacheManager cm = (ICacheManager)topicPart.getAdapter(ICacheManager.class);
        if (cm != null) {
            IAudioNotesAgentListener listener = new IAudioNotesAgentListener(){

                public void valuesChanged(ITopic topic, AudioValues values, boolean recordOrPlayback) {
                }

                public void stopped(ITopic topic, boolean recordOrPlayback) {
                    if (!recordOrPlayback) {
                        topicPart.refresh();
                    }
                }

                public void started(ITopic topic, boolean recordOrPlayback) {
                    if (!recordOrPlayback) {
                        topicPart.refresh();
                    }
                }
            };
            AudioNotesPlugin.getDefault().getAgent().addAudioListener(topicPart.getTopic(), listener);
            cm.setCache(CACHE_AUDIO_LISTENER, (Object)listener);
        }
    }

    public void topicDeactivated(ITopicPart topicPart) {
        IAudioNotesAgentListener listener = (IAudioNotesAgentListener)MindMapUtils.flushCache((IPart)topicPart, (String)CACHE_AUDIO_LISTENER);
        if (listener != null) {
            AudioNotesPlugin.getDefault().getAgent().removeAudioListener(topicPart.getTopic(), listener);
        }
        super.topicDeactivated(topicPart);
    }

    public List<IAction> getPopupMenuActions(ITopicPart topicPart, final ITopic topic) {
        Action saveAudioNotesAction = new Action(Messages.AudioNotesInfoItem_SaveAction_label){

            public void run() {
                AudioNotesInfoItemContributor.this.saveAudioNotesAs(topic);
            }
        };
        Action viewAudioNotesAcion = new Action(Messages.AudioNotesInfoItem_ViewAction_label){

            public void run() {
                AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
                if (agent.windowOpened) {
                    return;
                }
                if (agent.isPlaying()) {
                    long total = agent.getTotalSeconds(topic);
                    agent.jumpTo(total - 1L / total);
                    agent.stop();
                }
                AudioNotesPropertiesDialog dialog = new AudioNotesPropertiesDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                dialog.setContributedWorkbenchWindow(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                dialog.open();
            }
        };
        Action deleteAudioNotesAction = new Action(Messages.AudioNotesInfoItem_DeleteAction_label){

            public void run() {
                if (topic == null) {
                    return;
                }
                if (!AudioNotesInfoItemContributor.stopRecord(topic)) {
                    return;
                }
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window == null) {
                    return;
                }
                IGraphicalEditor editor = (IGraphicalEditor)window.getActivePage().getActiveEditor();
                if (editor == null) {
                    return;
                }
                DeleteAudioNotesCommand deleteAudioNotesCommand = new DeleteAudioNotesCommand(topic);
                ICommandStack cs = editor.getCommandStack();
                if (deleteAudioNotesCommand != null) {
                    cs.execute((Command)deleteAudioNotesCommand);
                }
            }
        };
        deleteAudioNotesAction.setImageDescriptor(null);
        ArrayList<IAction> list = new ArrayList<IAction>();
        list.add((IAction)viewAudioNotesAcion);
        list.add((IAction)saveAudioNotesAction);
        list.add((IAction)deleteAudioNotesAction);
        return list;
    }

    private Object saveAudioNotesAs(ITopic topic) {
        Program p;
        if (!AudioNotesInfoItemContributor.stopRecord(topic)) {
            return null;
        }
        String path = this.getAudioEntryPath(topic);
        if (path == null) {
            return null;
        }
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
        String ext = FileUtils.getExtension((String)path);
        dialog.setFilterExtensions(new String[]{"*" + ext, "*.*"});
        String extension = ext;
        if (ext != null && (p = Program.findProgram((String)ext)) != null) {
            extension = p.getName();
        }
        dialog.setFilterNames(new String[]{extension, NLS.bind((String)"{0} (*.*)", (Object)DialogMessages.AllFilesFilterName)});
        dialog.setFileName(FileUtils.getNoExtensionFileName((String)path));
        dialog.setOverwrite(true);
        String filePath = dialog.open();
        if (filePath == null) {
            return null;
        }
        try {
            InputStream is = topic.getOwnedWorkbook().getManifest().getFileEntry(path).openInputStream();
            FileUtils.transfer((InputStream)is, (OutputStream)new FileOutputStream(filePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getAudioEntryPath(ITopic topic) {
        List resourceRefs;
        ITopicExtension extension = topic.getExtension("org.xmind.ui.audionotes");
        if (extension != null && !(resourceRefs = extension.getResourceRefs()).isEmpty()) {
            for (IResourceRef ref : resourceRefs) {
                String entryPath;
                if (!"file-entry".equals(ref.getType()) || (entryPath = ref.getResourceId()) == null) continue;
                return entryPath;
            }
        }
        return null;
    }

    private static class StartPlayingAction
    extends Action {
        private ITopic topic;

        public StartPlayingAction(ITopic topic) {
            super(null, AudioNotesPlugin.imageFrom("icons/audio_play.png"));
            this.setDisabledImageDescriptor(AudioNotesPlugin.imageFrom("icons/audio_play.png"));
            this.setToolTipText(Messages.StartPlayingAction_toolTip);
            this.topic = topic;
        }

        public void run() {
            AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
            if (!agent.isRecording()) {
                agent.startPlay(this.topic);
            }
        }
    }

    private static class StopPlayingAction
    extends Action {
        private ITopic topic;

        public StopPlayingAction(ITopic topic) {
            super(null, AudioNotesPlugin.imageFrom("icons/audio_stop.png"));
            this.setDisabledImageDescriptor(AudioNotesPlugin.imageFrom("icons/audio_stop.png"));
            this.setToolTipText(Messages.StopPlayingAction_toolTip);
            this.topic = topic;
        }

        public void run() {
            AudioNotesAgent agent = AudioNotesPlugin.getDefault().getAgent();
            if (agent.isPlaying() && this.topic.equals(agent.getCurrentTopic())) {
                agent.pauseAt = -1.0;
                long total = agent.getTotalSeconds(this.topic);
                agent.jumpTo(total - 1L / total);
            }
        }
    }

    private static class StopRecordingAction
    extends Action {
        private ITopic topic;

        public StopRecordingAction(ITopic topic) {
            super(null, AudioNotesPlugin.imageFrom("icons/audio_stop.png"));
            this.setDisabledImageDescriptor(AudioNotesPlugin.imageFrom("icons/audio_stop.png"));
            this.setToolTipText(Messages.StopRecordingAction_toolTip);
            this.topic = topic;
        }

        public void run() {
            AudioNotesInfoItemContributor.stopRecord(this.topic);
        }
    }
}

