/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation.test;

import com.sun.electric.tool.simulation.test.BitVector;
import com.sun.electric.tool.simulation.test.ChainNode;
import com.sun.electric.tool.simulation.test.ChipNode;
import com.sun.electric.tool.simulation.test.Infrastructure;
import com.sun.electric.tool.simulation.test.JtagTester;
import com.sun.electric.tool.simulation.test.MyTreeNode;

public abstract class NetscanGeneric
extends JtagTester {
    public static final short DEFAULT_STOP_STATE = 1;
    private static int numInstances = 0;
    public static final boolean newInstructionRegister = true;

    @Override
    void shift(ChainNode chain2, boolean readEnable, boolean writeEnable, int irBadSeverity) {
        int result2 = this.netScan_IR(chain2, readEnable, writeEnable, irBadSeverity);
        if (result2 == 0) {
            this.netScan_DR(chain2);
        }
        if (NetscanGeneric.isBypassChain(chain2) && !chain2.getOutBits().isEmpty()) {
            Infrastructure.fatal("Bypass register returned non-zero value");
        }
    }

    protected abstract int hw_net_scan_ir(int var1, short[] var2, short[] var3, int var4);

    protected abstract int hw_net_scan_dr(int var1, short[] var2, short[] var3);

    protected static void incrementNumTesters() {
        if (++numInstances > 1) {
            Infrastructure.fatal("The Netscan SFL libraries can only be used with one Corelis JTAG tester at a time.  Thus only one NetscanGeneric (i.e., Netscan or Netscan4) object is allowed in a given JVM.");
        }
    }

    protected static String shortsToString(short[] shorts) {
        StringBuffer buffer = new StringBuffer();
        for (int iShort = shorts.length - 1; iShort >= 0; --iShort) {
            for (int iBit = 15; iBit >= 0; --iBit) {
                int bitValue = shorts[iShort] >> iBit & 1;
                buffer.append(Integer.toString(bitValue));
            }
            buffer.append(" ");
        }
        return buffer.toString();
    }

    private static boolean isBypassChain(ChainNode chain2) {
        int i;
        int numEnableBits = 2;
        StringBuffer bypassCode = new StringBuffer();
        for (i = 0; i < chain2.getParentChip().getLengthIR() - numEnableBits; ++i) {
            bypassCode.append('1');
        }
        for (i = 0; i < numEnableBits; ++i) {
            bypassCode.append('0');
        }
        String opcode = NetscanGeneric.padOpcode(chain2.getOpcode(), chain2.getParentChip().getLengthIR(), false, false);
        return opcode.equals(bypassCode.toString());
    }

    private int netScan_IR(ChainNode chain2, boolean readEnable, boolean writeEnable, int irBadSeverity) {
        String irbits = NetscanGeneric.getInstructionRegister(chain2, readEnable, writeEnable);
        short[] scanIn = NetscanGeneric.instructionRegisterToShorts(irbits);
        int numShorts = irbits.length() / 16 + 1;
        short[] scanOut = new short[numShorts];
        MyTreeNode root = chain2.getParentChip().getParent();
        int numPrebits = 0;
        int numPostbits = 0;
        boolean foundChain = false;
        for (int i = 0; i < root.getChildCount(); ++i) {
            MyTreeNode child = root.getChildAt(i);
            if (!(child instanceof ChipNode)) continue;
            ChipNode chip = (ChipNode)child;
            if (chip == chain2.getParentChip()) {
                foundChain = true;
                continue;
            }
            if (foundChain) {
                ++numPostbits;
                continue;
            }
            ++numPrebits;
        }
        int result2 = this.hw_net_scan_ir(irbits.length(), scanIn, scanOut, chain2.getInBits().getNumBits() + numPrebits + numPostbits);
        if (result2 != 0) {
            Infrastructure.fatal("net_scan_ir returned error code 0x" + Integer.toHexString(result2));
        } else {
            String outirbits = NetscanGeneric.shortsToString(scanOut);
            outirbits = outirbits.replaceAll("\\s", "");
            outirbits = outirbits.substring(outirbits.length() - irbits.length());
            boolean badValue = false;
            char zero = '0';
            char one = '1';
            if (this.isScanOutInverted()) {
                zero = '1';
                one = '0';
            }
            root = chain2.getParentChip().getParent();
            int ind = 0;
            for (int i = 0; i < root.getChildCount(); ++i) {
                MyTreeNode child = root.getChildAt(i);
                if (!(child instanceof ChipNode)) continue;
                ChipNode chip = (ChipNode)child;
                int j = 0;
                for (j = 0; j < chip.getLengthIR() - 1; ++j) {
                    if (outirbits.charAt(ind + j) == zero) continue;
                    badValue = true;
                }
                if (outirbits.charAt(ind + j) != one) {
                    badValue = true;
                }
                ind += chip.getLengthIR();
            }
            if (badValue) {
                Infrastructure.error(irBadSeverity, "Bad IR scan out " + NetscanGeneric.shortsToString(scanOut) + ", expected 1. IR scan in was " + irbits + ". Possible " + "causes: bad or too-long JTAG cable, " + "bad jtagVolts or jtagKhz values in " + "ChainControl constructor, bad Vdd to chip, " + "broken JTAG controller or JTAG tester, " + "ill-tempered gremlins.");
            }
        }
        return result2;
    }

    static String getInstructionRegister(ChainNode chain2, boolean readEnable, boolean writeEnable) {
        MyTreeNode root = chain2.getParentChip().getParent();
        StringBuffer ir = new StringBuffer();
        for (int i = 0; i < root.getChildCount(); ++i) {
            MyTreeNode child = root.getChildAt(i);
            if (!(child instanceof ChipNode)) continue;
            ChipNode chip = (ChipNode)child;
            if (chip == chain2.getParentChip()) {
                ir.append(NetscanGeneric.padOpcode(chain2.getOpcode(), chip.getLengthIR(), readEnable, writeEnable));
                continue;
            }
            for (int j = 0; j < chip.getLengthIR(); ++j) {
                ir.append('1');
            }
        }
        return ir.toString();
    }

    private static String padOpcode(String opcode, int lengthIR, boolean readEnable, boolean writeEnable) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < lengthIR - opcode.length(); ++i) {
            buf.append("0");
        }
        buf.append(opcode);
        buf.setCharAt(1, writeEnable ? (char)'1' : '0');
        buf.setCharAt(0, readEnable ? (char)'1' : '0');
        return buf.toString();
    }

    static short[] instructionRegisterToShorts(String instructionRegister) {
        return NetscanGeneric.opcodeToShorts(instructionRegister, instructionRegister.length());
    }

    private static short[] opcodeToShorts(String opcode, int lengthIR) {
        int numBits = opcode.length();
        if (numBits <= 0 || numBits > lengthIR) {
            Infrastructure.fatal("opcode.length()=" + numBits + " is outside allowed range 1.." + lengthIR);
        }
        short[] shorts = new short[(numBits - 1) / 16 + 1];
        for (int ind = 0; ind < opcode.length(); ++ind) {
            char ch = opcode.charAt(opcode.length() - ind - 1);
            if (ch == '1') {
                int n = ind / 16;
                shorts[n] = (short)(shorts[n] | 1 << ind % 16);
                continue;
            }
            if (ch == '0') continue;
            Infrastructure.fatal("Bad character " + ch + " in bit string, only 0 and 1 allowed");
        }
        return shorts;
    }

    private int netScan_DR(ChainNode chain2) {
        MyTreeNode root = chain2.getParentChip().getParent();
        int numPrebits = 0;
        int numPostbits = 0;
        boolean foundChain = false;
        for (int i = 0; i < root.getChildCount(); ++i) {
            MyTreeNode child = root.getChildAt(i);
            if (!(child instanceof ChipNode)) continue;
            ChipNode chip = (ChipNode)child;
            if (chip == chain2.getParentChip()) {
                foundChain = true;
                continue;
            }
            if (foundChain) {
                ++numPostbits;
                continue;
            }
            ++numPrebits;
        }
        BitVector scanInBits = NetscanGeneric.padBitVector(chain2.getInBits(), numPrebits, numPostbits);
        short[] scanIn = NetscanGeneric.bitsToDataRegister(scanInBits);
        int numShorts = scanInBits.getNumBits() / 16 + 1;
        short[] scanOut = new short[numShorts];
        int result2 = this.hw_net_scan_dr(scanInBits.getNumBits(), scanIn, scanOut);
        if (result2 != 0) {
            Infrastructure.fatal("net_scan_dr returned error code 0x" + Integer.toHexString(result2));
        }
        BitVector outBits = NetscanGeneric.dataRegisterToBits(scanOut, scanInBits.getNumBits());
        if (this.isScanOutInverted()) {
            outBits.flip(0, outBits.getNumBits());
        }
        outBits = NetscanGeneric.stripBitVector(outBits, numPrebits, numPostbits);
        chain2.setOutBits(outBits);
        return result2;
    }

    private static void setShortsBit(short[] shorts, int index, boolean value) {
        if (value) {
            int n = index / 16;
            shorts[n] = (short)(shorts[n] | 1 << index % 16);
        } else {
            int n = index / 16;
            shorts[n] = (short)(shorts[n] & ~(1 << index % 16));
        }
    }

    public static BitVector padBitVector(BitVector bits2, int numPre, int numPost) {
        int numNewBits = numPre + numPost + bits2.getNumBits();
        BitVector newBits = new BitVector(numNewBits, bits2.getName());
        for (int j = 0; j < numNewBits; ++j) {
            newBits.clear(j);
        }
        newBits.put(numPre, bits2);
        return newBits;
    }

    private static BitVector stripBitVector(BitVector bits2, int numPre, int numPost) {
        int numBits = bits2.getNumBits() - numPre - numPost;
        return bits2.get(numPre, numBits);
    }

    private static short[] bitsToDataRegister(BitVector bits2) {
        int numBits = bits2.getNumBits();
        if (numBits < 0) {
            Infrastructure.fatal("bad numBits = " + numBits);
        }
        short[] shorts = new short[(numBits - 1) / 16 + 1];
        for (int ind = 0; ind < numBits; ++ind) {
            if (!bits2.get(numBits - ind - 1)) continue;
            int n = ind / 16;
            shorts[n] = (short)(shorts[n] | 1 << ind % 16);
        }
        return shorts;
    }

    private static BitVector dataRegisterToBits(short[] shorts, int numBits) {
        if (numBits < 0 || numBits > shorts.length * 16) {
            Infrastructure.fatal("BAD NUMBITS = " + numBits);
        }
        BitVector bits2 = new BitVector(numBits, "dataRegisterToBits.bits");
        for (int ind = 0; ind < numBits; ++ind) {
            boolean value = (shorts[ind / 16] & 1 << ind % 16) != 0;
            bits2.set(numBits - ind - 1, value);
        }
        return bits2;
    }

    public static void main(String[] args) {
        short[] inp = new short[]{3, 172, -256};
        BitVector bits2 = new BitVector(0, "main().bits");
        System.out.print("Shorts in (descending): " + NetscanGeneric.shortsToString(inp));
        for (int numBits = 0; numBits <= inp.length * 16; numBits += 4) {
            bits2 = NetscanGeneric.dataRegisterToBits(inp, numBits);
            System.out.println(numBits + ":" + bits2);
        }
        System.out.println("BitVector in: " + bits2);
        short[] out = NetscanGeneric.bitsToDataRegister(bits2);
        System.out.print("DataRegister:" + NetscanGeneric.shortsToString(out));
        String opcode = args.length > 0 ? args[0] : "1011";
        out = NetscanGeneric.instructionRegisterToShorts(NetscanGeneric.padOpcode(opcode, 8, true, true));
        System.out.println("IR: " + NetscanGeneric.shortsToString(out));
        out = NetscanGeneric.instructionRegisterToShorts(NetscanGeneric.padOpcode(opcode, 8, false, false));
        System.out.println("IR: " + NetscanGeneric.shortsToString(out));
    }
}

