/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.Date;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.languagetool.tools.StringTools;

public final class HTTPTestTools {
    private HTTPTestTools() {
    }

    public static int getDefaultPort() {
        String defaultPort = System.getProperty("lt.default.port");
        return defaultPort != null ? Integer.parseInt(defaultPort) : 8081;
    }

    public static void disableCertChecks() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    public static String checkAtUrl(URL url) throws IOException {
        try {
            InputStream stream = (InputStream)url.getContent();
            return StringTools.streamToString((InputStream)stream, (String)"UTF-8");
        }
        catch (ConnectException e) {
            throw new RuntimeException("Could not connect to " + url, e);
        }
    }

    public static String checkAtUrlByPost(URL url, String postData) throws IOException {
        return HTTPTestTools.checkAtUrlByPost(url, postData, new HashMap<String, String>());
    }

    /*
     * Loose catch block
     */
    public static String checkAtUrlByPost(URL url, String postData, Map<String, String> properties) throws IOException {
        String keepAlive = System.getProperty("http.keepAlive");
        try {
            System.setProperty("http.keepAlive", "false");
            URLConnection connection = url.openConnection();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            connection.setDoOutput(true);
            try (OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream(), StandardCharsets.UTF_8);){
                writer.write(postData);
                ((Writer)writer).flush();
                String string = StringTools.streamToString((InputStream)connection.getInputStream(), (String)"UTF-8");
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (keepAlive != null) {
                System.setProperty("http.keepAlive", keepAlive);
            }
        }
    }

    static class TestData {
        public static final String TOKEN_V2_1 = "4472b043ce935018e1a5bf5ef4b8a21b";
        public static final Long USER_GROUP_1 = 1L;
        public static final String NAME1 = "One";
        protected static final String USERNAME1 = "test@test.de";
        protected static final String API_KEY1 = "foo";
        protected static final long USER_ID1 = 1L;
        protected static final Date PREMIUM_FROM1 = Date.valueOf("1970-01-01");
        protected static final String NAME2 = "Two";
        protected static final String USERNAME2 = "two@test.de";
        protected static final String API_KEY2 = "foo-two";
        protected static final Date PREMIUM_FROM2 = Date.valueOf("2000-01-01");
        protected static final long USER_ID2 = 2L;
        protected static final String USERNAME3 = "free-account@example.com";
        protected static final String NAME3 = "Three";
        protected static final String PASSWORD3 = "password";
        protected static final long USER_ID3 = 3L;

        TestData() {
        }
    }
}

