/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.psi.java1.gcf.datagram;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.Properties;
import javax.microedition.io.Datagram;
import javax.microedition.io.UDPDatagramConnection;
import org.me4se.impl.ConnectionImpl;
import org.me4se.psi.java1.gcf.datagram.DatagramImpl;

public class DatagramConnectionImpl
extends ConnectionImpl
implements UDPDatagramConnection {
    DatagramSocket datagramsocket;
    String host;
    int port;

    public void open(String url, int mode, boolean timeouts) throws IOException {
        int cut = url.lastIndexOf(58);
        if (cut >= 11) {
            this.host = url.substring(11, cut);
            this.port = Integer.parseInt(url.substring(cut + 1));
        } else {
            this.host = url.substring(11);
        }
        this.datagramsocket = this.host.length() == 0 ? new DatagramSocket(this.port) : new DatagramSocket();
    }

    public void close() throws IOException {
        this.datagramsocket.close();
    }

    public void initialise(Properties properties) {
    }

    public int getMaximumLength() throws IOException {
        return 1024;
    }

    public int getNominalLength() throws IOException {
        return 1024;
    }

    public void send(Datagram dgram) throws IOException {
        this.datagramsocket.send(((DatagramImpl)dgram).getPacket());
    }

    public void receive(Datagram dgram) throws IOException {
        DatagramPacket dp = ((DatagramImpl)dgram).getPacket();
        this.datagramsocket.receive(dp);
        dgram.setData(dp.getData(), dp.getOffset(), dp.getLength());
        dgram.setLength(dp.getLength());
    }

    public Datagram newDatagram(int size) throws IOException {
        return this.newDatagram(new byte[size], size, "datagram://" + this.host + ":" + Integer.toString(this.port));
    }

    public Datagram newDatagram(int size, String addr) throws IOException {
        return this.newDatagram(new byte[size], size, addr);
    }

    public Datagram newDatagram(byte[] buf, int size) throws IOException {
        return this.newDatagram(buf, size, "datagram://" + this.host + ":" + Integer.toString(this.port));
    }

    public Datagram newDatagram(byte[] buf, int size, String addr) throws IOException {
        return new DatagramImpl(buf, size, addr);
    }

    public String getLocalAddress() throws IOException {
        return this.datagramsocket.getLocalAddress().getHostAddress();
    }

    public int getLocalPort() throws IOException {
        return this.datagramsocket.getLocalPort();
    }
}

