/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.DependencyArtifactsVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.FileDependencyArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantCache;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VariantResolvingArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphEdge;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.type.ArtifactTypeRegistry;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.resolver.DefaultVariantArtifactResolver;
import org.gradle.internal.resolve.resolver.VariantArtifactResolver;

public class ResolvedArtifactsGraphVisitor
implements DependencyGraphVisitor {
    private int nextId;
    private final Long2ObjectMap<ArtifactsForNode> artifactsByNodeId = new Long2ObjectOpenHashMap();
    private final DependencyArtifactsVisitor artifactResults;
    private final ArtifactTypeRegistry artifactTypeRegistry;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final VariantArtifactResolver variantResolver;

    public ResolvedArtifactsGraphVisitor(DependencyArtifactsVisitor artifactsBuilder, ArtifactTypeRegistry artifactTypeRegistry, CalculatedValueContainerFactory calculatedValueContainerFactory, ArtifactResolver artifactResolver, ResolvedVariantCache resolvedVariantCache) {
        this.artifactResults = artifactsBuilder;
        this.artifactTypeRegistry = artifactTypeRegistry;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.variantResolver = new DefaultVariantArtifactResolver(artifactResolver, artifactTypeRegistry, resolvedVariantCache);
    }

    @Override
    public void start(RootGraphNode root) {
        this.artifactResults.startArtifacts(root);
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        this.artifactResults.visitNode(node);
    }

    @Override
    public void visitSelector(DependencyGraphSelector selector) {
    }

    @Override
    public void visitEdges(DependencyGraphNode node) {
        for (DependencyGraphEdge dependencyGraphEdge : node.getIncomingEdges()) {
            if (!dependencyGraphEdge.contributesArtifacts()) continue;
            DependencyGraphNode parent = dependencyGraphEdge.getFrom();
            ArtifactsForNode artifacts = this.resolveVariantArtifacts(dependencyGraphEdge, node);
            this.artifactResults.visitArtifacts(parent, node, artifacts.artifactSetId, artifacts.artifactSet);
        }
        for (LocalFileDependencyMetadata localFileDependencyMetadata : node.getOutgoingFileEdges()) {
            int id;
            ++this.nextId;
            this.artifactResults.visitArtifacts(node, localFileDependencyMetadata, id, (ArtifactSet)new FileDependencyArtifactSet(localFileDependencyMetadata, this.artifactTypeRegistry, this.calculatedValueContainerFactory));
        }
    }

    @Override
    public void finish(DependencyGraphNode root) {
        this.artifactResults.finishArtifacts();
        this.artifactsByNodeId.clear();
    }

    private ArtifactsForNode resolveVariantArtifacts(DependencyGraphEdge dependency, DependencyGraphNode toNode) {
        ComponentGraphResolveState component = toNode.getOwner().getResolveState();
        VariantGraphResolveState variant = toNode.getResolveState();
        if (!dependency.getDependencyMetadata().getArtifacts().isEmpty() || !dependency.getAttributes().isEmpty() || dependency.getExclusions().mayExcludeArtifacts()) {
            int id = this.nextId++;
            return new ArtifactsForNode(id, new VariantResolvingArtifactSet(this.variantResolver, component, variant, dependency));
        }
        return (ArtifactsForNode)this.artifactsByNodeId.computeIfAbsent(toNode.getNodeId().longValue(), value -> {
            int id = this.nextId++;
            return new ArtifactsForNode(id, new VariantResolvingArtifactSet(this.variantResolver, component, variant, dependency));
        });
    }

    private static class ArtifactsForNode {
        private final int artifactSetId;
        private final ArtifactSet artifactSet;

        ArtifactsForNode(int artifactSetId, ArtifactSet artifactSet) {
            this.artifactSetId = artifactSetId;
            this.artifactSet = artifactSet;
        }
    }
}

