/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publication;

import com.google.common.collect.Streams;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.publish.VersionMappingStrategy;
import org.gradle.api.publish.internal.CompositePublicationArtifactSet;
import org.gradle.api.publish.internal.DefaultPublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationArtifactInternal;
import org.gradle.api.publish.internal.PublicationArtifactSet;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.ivy.InvalidIvyPublicationException;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.IvyConfigurationContainer;
import org.gradle.api.publish.ivy.IvyModuleDescriptorSpec;
import org.gradle.api.publish.ivy.internal.artifact.DefaultIvyArtifactSet;
import org.gradle.api.publish.ivy.internal.artifact.DerivedIvyArtifact;
import org.gradle.api.publish.ivy.internal.artifact.IvyArtifactInternal;
import org.gradle.api.publish.ivy.internal.artifact.NormalizedIvyArtifact;
import org.gradle.api.publish.ivy.internal.artifact.SingleOutputTaskIvyArtifact;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfigurationContainer;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyModuleDescriptorSpec;
import org.gradle.api.publish.ivy.internal.publication.IvyComponentParser;
import org.gradle.api.publish.ivy.internal.publication.IvyModuleDescriptorSpecInternal;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationCoordinates;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Cast;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.internal.GUtil;

public abstract class DefaultIvyPublication
implements IvyPublicationInternal {
    private final String name;
    private final IvyPublicationCoordinates publicationCoordinates;
    private final VersionMappingStrategyInternal versionMappingStrategy;
    private final TaskDependencyFactory taskDependencyFactory;
    private final ImmutableAttributesFactory immutableAttributesFactory;
    private final IvyModuleDescriptorSpecInternal descriptor;
    private final IvyConfigurationContainer configurations;
    private final DefaultIvyArtifactSet mainArtifacts;
    private final PublicationArtifactSet<IvyArtifact> metadataArtifacts;
    private final PublicationArtifactSet<IvyArtifact> derivedArtifacts;
    private final PublicationArtifactSet<IvyArtifact> publishableArtifacts;
    private final SetProperty<IvyArtifact> componentArtifacts;
    private final SetProperty<IvyConfiguration> componentConfigurations;
    private final Set<String> silencedVariants = new HashSet<String>();
    private IvyArtifact ivyDescriptorArtifact;
    private TaskProvider<? extends Task> moduleDescriptorGenerator;
    private SingleOutputTaskIvyArtifact gradleModuleDescriptorArtifact;
    private boolean alias;
    private boolean populated;
    private boolean artifactsOverridden;
    private boolean silenceAllPublicationWarnings;
    private boolean withBuildIdentifier;

    @Inject
    public DefaultIvyPublication(String name, Instantiator instantiator, ObjectFactory objectFactory, IvyPublicationCoordinates publicationCoordinates, NotationParser<Object, IvyArtifact> ivyArtifactNotationParser, FileCollectionFactory fileCollectionFactory, ImmutableAttributesFactory immutableAttributesFactory, CollectionCallbackActionDecorator collectionCallbackActionDecorator, VersionMappingStrategyInternal versionMappingStrategy, TaskDependencyFactory taskDependencyFactory, ProviderFactory providerFactory) {
        this.name = name;
        this.publicationCoordinates = publicationCoordinates;
        this.immutableAttributesFactory = immutableAttributesFactory;
        this.versionMappingStrategy = versionMappingStrategy;
        this.taskDependencyFactory = taskDependencyFactory;
        IvyComponentParser ivyComponentParser = (IvyComponentParser)objectFactory.newInstance(IvyComponentParser.class, new Object[]{ivyArtifactNotationParser});
        this.componentArtifacts = objectFactory.setProperty(IvyArtifact.class);
        this.componentArtifacts.convention(this.getComponent().map(ivyComponentParser::parseArtifacts));
        this.componentArtifacts.finalizeValueOnRead();
        this.componentConfigurations = objectFactory.setProperty(IvyConfiguration.class);
        this.componentConfigurations.convention(this.getComponent().map(ivyComponentParser::parseConfigurations));
        this.componentConfigurations.finalizeValueOnRead();
        this.mainArtifacts = (DefaultIvyArtifactSet)instantiator.newInstance(DefaultIvyArtifactSet.class, new Object[]{name, ivyArtifactNotationParser, fileCollectionFactory, collectionCallbackActionDecorator});
        this.metadataArtifacts = new DefaultPublicationArtifactSet(IvyArtifact.class, "metadata artifacts for " + name, fileCollectionFactory, collectionCallbackActionDecorator);
        this.derivedArtifacts = new DefaultPublicationArtifactSet(IvyArtifact.class, "derived artifacts for " + name, fileCollectionFactory, collectionCallbackActionDecorator);
        this.publishableArtifacts = new CompositePublicationArtifactSet(taskDependencyFactory, IvyArtifact.class, (PublicationArtifactSet[])Cast.uncheckedCast((Object)new PublicationArtifactSet[]{this.mainArtifacts, this.metadataArtifacts, this.derivedArtifacts}));
        this.configurations = (IvyConfigurationContainer)instantiator.newInstance(DefaultIvyConfigurationContainer.class, new Object[]{instantiator, collectionCallbackActionDecorator});
        this.descriptor = (IvyModuleDescriptorSpecInternal)objectFactory.newInstance(DefaultIvyModuleDescriptorSpec.class, new Object[]{objectFactory, publicationCoordinates});
        this.descriptor.setStatus("integration");
        this.descriptor.getWriteGradleMetadataMarker().set(providerFactory.provider(this::writeGradleMetadataMarker));
        this.descriptor.getGlobalExcludes().set(this.getComponent().map(ivyComponentParser::parseGlobalExcludes));
        this.descriptor.getConfigurations().set((Iterable)((Object)this.configurations));
        this.descriptor.getArtifacts().set(providerFactory.provider(this::getArtifacts));
        this.descriptor.getDependencies().set(this.getComponent().map(component -> {
            IvyComponentParser.ParsedDependencyResult result = ivyComponentParser.parseDependencies((SoftwareComponentInternal)component, versionMappingStrategy);
            if (!this.silenceAllPublicationWarnings) {
                result.getWarnings().complete(this.getDisplayName() + " ivy metadata", this.silencedVariants);
            }
            return result.getDependencies();
        }));
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void withoutBuildIdentifier() {
        this.withBuildIdentifier = false;
    }

    public void withBuildIdentifier() {
        this.withBuildIdentifier = true;
    }

    public boolean isPublishBuildId() {
        return this.withBuildIdentifier;
    }

    public DisplayName getDisplayName() {
        return Describables.withTypeAndName((Object)"Ivy publication", (String)this.name);
    }

    public boolean isLegacy() {
        return false;
    }

    public abstract Property<SoftwareComponentInternal> getComponent();

    @Override
    public IvyModuleDescriptorSpecInternal getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void setIvyDescriptorGenerator(TaskProvider<? extends Task> descriptorGenerator) {
        if (this.ivyDescriptorArtifact != null) {
            this.metadataArtifacts.remove((Object)this.ivyDescriptorArtifact);
        }
        this.ivyDescriptorArtifact = new SingleOutputTaskIvyArtifact(descriptorGenerator, this.publicationCoordinates, "xml", "ivy", null, this.taskDependencyFactory);
        this.ivyDescriptorArtifact.setName("ivy");
        this.metadataArtifacts.add((Object)this.ivyDescriptorArtifact);
    }

    @Override
    public void setModuleDescriptorGenerator(TaskProvider<? extends Task> descriptorGenerator) {
        this.moduleDescriptorGenerator = descriptorGenerator;
        if (this.gradleModuleDescriptorArtifact != null) {
            this.metadataArtifacts.remove((Object)this.gradleModuleDescriptorArtifact);
        }
        this.gradleModuleDescriptorArtifact = null;
        this.updateModuleDescriptorArtifact();
    }

    private void updateModuleDescriptorArtifact() {
        if (!this.canPublishModuleMetadata()) {
            return;
        }
        if (this.moduleDescriptorGenerator == null) {
            return;
        }
        this.gradleModuleDescriptorArtifact = new SingleOutputTaskIvyArtifact(this.moduleDescriptorGenerator, this.publicationCoordinates, "module", "json", null, this.taskDependencyFactory);
        this.metadataArtifacts.add((Object)this.gradleModuleDescriptorArtifact);
        this.moduleDescriptorGenerator = null;
    }

    @Override
    public void descriptor(Action<? super IvyModuleDescriptorSpec> configure) {
        configure.execute((Object)this.descriptor);
    }

    public boolean isAlias() {
        return this.alias;
    }

    public void setAlias(boolean alias) {
        this.alias = alias;
    }

    @Override
    public void from(SoftwareComponent component) {
        if (this.getComponent().isPresent()) {
            throw new InvalidUserDataException(String.format("Ivy publication '%s' cannot include multiple components", this.name));
        }
        this.getComponent().set((Object)((SoftwareComponentInternal)component));
        this.getComponent().finalizeValue();
        this.artifactsOverridden = false;
        this.updateModuleDescriptorArtifact();
    }

    private void populateFromComponent() {
        if (this.populated) {
            return;
        }
        this.populated = true;
        if (!this.artifactsOverridden && this.componentArtifacts.isPresent()) {
            this.mainArtifacts.addAll((Collection)this.componentArtifacts.get());
        }
        if (this.componentConfigurations.isPresent()) {
            this.configurations.addAll((Collection)this.componentConfigurations.get());
        }
    }

    @Override
    public void configurations(Action<? super IvyConfigurationContainer> config) {
        this.populateFromComponent();
        config.execute((Object)this.configurations);
    }

    @Override
    public IvyConfigurationContainer getConfigurations() {
        this.populateFromComponent();
        return this.configurations;
    }

    @Override
    public IvyArtifact artifact(Object source) {
        return this.mainArtifacts.artifact(source);
    }

    @Override
    public IvyArtifact artifact(Object source, Action<? super IvyArtifact> config) {
        return this.mainArtifacts.artifact(source, config);
    }

    @Override
    public void setArtifacts(Iterable<?> sources) {
        this.artifactsOverridden = true;
        this.mainArtifacts.clear();
        for (Object source : sources) {
            this.artifact(source);
        }
    }

    @Override
    public DefaultIvyArtifactSet getArtifacts() {
        this.populateFromComponent();
        return this.mainArtifacts;
    }

    @Override
    public String getOrganisation() {
        return (String)this.descriptor.getCoordinates().getOrganisation().get();
    }

    @Override
    public void setOrganisation(String organisation) {
        this.descriptor.getCoordinates().getOrganisation().set((Object)organisation);
    }

    @Override
    public String getModule() {
        return (String)this.descriptor.getCoordinates().getModule().get();
    }

    @Override
    public void setModule(String module) {
        this.descriptor.getCoordinates().getModule().set((Object)module);
    }

    @Override
    public String getRevision() {
        return (String)this.descriptor.getCoordinates().getRevision().get();
    }

    @Override
    public void setRevision(String revision) {
        this.descriptor.getCoordinates().getRevision().set((Object)revision);
    }

    public PublicationArtifactSet<IvyArtifact> getPublishableArtifacts() {
        this.populateFromComponent();
        return this.publishableArtifacts;
    }

    public void allPublishableArtifacts(Action<? super IvyArtifact> action) {
        this.publishableArtifacts.all(action);
    }

    public void whenPublishableArtifactRemoved(Action<? super IvyArtifact> action) {
        this.publishableArtifacts.whenObjectRemoved(action);
    }

    public IvyArtifact addDerivedArtifact(IvyArtifact originalArtifact, PublicationInternal.DerivedArtifact fileProvider) {
        PublicationInternal.DerivedArtifact effectiveFileProvider = originalArtifact == this.gradleModuleDescriptorArtifact ? new GradleModuleDescriptorDerivedArtifact(fileProvider, this.gradleModuleDescriptorArtifact) : fileProvider;
        DerivedIvyArtifact artifact = new DerivedIvyArtifact(originalArtifact, effectiveFileProvider, this.taskDependencyFactory);
        this.derivedArtifacts.add((Object)artifact);
        return artifact;
    }

    public void removeDerivedArtifact(IvyArtifact artifact) {
        this.derivedArtifacts.remove((Object)artifact);
    }

    @Override
    public IvyNormalizedPublication asNormalisedPublication() {
        this.populateFromComponent();
        Set<IvyArtifact> main = DefaultIvyPublication.linkedHashSetOf(DefaultIvyPublication.normalized(this.mainArtifacts.stream(), this::isValidArtifact));
        LinkedHashSet<IvyArtifact> all = new LinkedHashSet<IvyArtifact>(main);
        DefaultIvyPublication.normalized(Streams.concat((Stream[])new Stream[]{this.metadataArtifacts.stream(), this.derivedArtifacts.stream()}), this::isPublishableArtifact).forEach(all::add);
        return new IvyNormalizedPublication(this.name, this.getCoordinates(), this.getIvyDescriptorFile(), all);
    }

    private static <T> Set<T> linkedHashSetOf(Stream<T> stream) {
        LinkedHashSet set = new LinkedHashSet();
        stream.forEach(set::add);
        return set;
    }

    private boolean isValidArtifact(IvyArtifact artifact) {
        File artifactFile = artifact.getFile();
        if (artifactFile == null) {
            throw new InvalidIvyPublicationException(this.name, String.format("artifact file does not exist: '%s'", artifact));
        }
        if (!((IvyArtifactInternal)artifact).shouldBePublished()) {
            if (artifact.getClassifier() == null) {
                throw new IllegalStateException("Artifact " + artifact.getFile().getName() + " wasn't produced by this build.");
            }
            return false;
        }
        return true;
    }

    private static Stream<IvyArtifact> normalized(Stream<IvyArtifact> artifacts, Predicate<IvyArtifact> predicate) {
        return artifacts.filter(predicate).map(DefaultIvyPublication::normalizedArtifactFor);
    }

    private boolean isPublishableArtifact(IvyArtifact element) {
        if (!((PublicationArtifactInternal)element).shouldBePublished()) {
            return false;
        }
        if (this.gradleModuleDescriptorArtifact == element) {
            return this.gradleModuleDescriptorArtifact.isEnabled();
        }
        return true;
    }

    private static NormalizedIvyArtifact normalizedArtifactFor(IvyArtifact artifact) {
        return ((IvyArtifactInternal)artifact).asNormalisedArtifact();
    }

    @Override
    public boolean writeGradleMetadataMarker() {
        return this.canPublishModuleMetadata() && this.gradleModuleDescriptorArtifact != null && this.gradleModuleDescriptorArtifact.isEnabled();
    }

    private boolean canPublishModuleMetadata() {
        return this.getComponent().isPresent();
    }

    private File getIvyDescriptorFile() {
        if (this.ivyDescriptorArtifact == null) {
            throw new IllegalStateException("ivyDescriptorArtifact not set for publication");
        }
        return this.ivyDescriptorArtifact.getFile();
    }

    public ModuleVersionIdentifier getCoordinates() {
        return DefaultModuleVersionIdentifier.newId((String)this.getOrganisation(), (String)this.getModule(), (String)this.getRevision());
    }

    @Nullable
    public <T> T getCoordinates(Class<T> type) {
        if (type.isAssignableFrom(ModuleVersionIdentifier.class)) {
            return type.cast(this.getCoordinates());
        }
        return null;
    }

    public ImmutableAttributes getAttributes() {
        return this.immutableAttributesFactory.of(ProjectInternal.STATUS_ATTRIBUTE, (Object)this.getDescriptor().getStatus());
    }

    private String getPublishedUrl(PublishArtifact source) {
        return this.getArtifactFileName(source.getClassifier(), source.getExtension());
    }

    private String getArtifactFileName(@Nullable String classifier, String extension) {
        StringBuilder artifactPath = new StringBuilder();
        ModuleVersionIdentifier coordinates = this.getCoordinates();
        artifactPath.append(coordinates.getName());
        artifactPath.append('-');
        artifactPath.append(coordinates.getVersion());
        if (GUtil.isTrue((Object)classifier)) {
            artifactPath.append('-');
            artifactPath.append(classifier);
        }
        if (GUtil.isTrue((Object)extension)) {
            artifactPath.append('.');
            artifactPath.append(extension);
        }
        return artifactPath.toString();
    }

    public PublicationInternal.PublishedFile getPublishedFile(PublishArtifact source) {
        final String publishedUrl = this.getPublishedUrl(source);
        return new PublicationInternal.PublishedFile(){

            public String getName() {
                return publishedUrl;
            }

            public String getUri() {
                return publishedUrl;
            }
        };
    }

    @Override
    public void versionMapping(Action<? super VersionMappingStrategy> configureAction) {
        configureAction.execute((Object)this.versionMappingStrategy);
    }

    @Override
    public void suppressIvyMetadataWarningsFor(String variantName) {
        this.silencedVariants.add(variantName);
    }

    @Override
    public void suppressAllIvyMetadataWarnings() {
        this.silenceAllPublicationWarnings = true;
    }

    public VersionMappingStrategyInternal getVersionMappingStrategy() {
        return this.versionMappingStrategy;
    }

    private static class GradleModuleDescriptorDerivedArtifact
    implements PublicationInternal.DerivedArtifact {
        private final PublicationInternal.DerivedArtifact derivedArtifact;
        private final SingleOutputTaskIvyArtifact gradleModuleDescriptorArtifact;

        public GradleModuleDescriptorDerivedArtifact(PublicationInternal.DerivedArtifact derivedArtifact, SingleOutputTaskIvyArtifact gradleModuleDescriptorArtifact) {
            this.derivedArtifact = derivedArtifact;
            this.gradleModuleDescriptorArtifact = gradleModuleDescriptorArtifact;
        }

        @Nullable
        public File create() {
            return this.derivedArtifact.create();
        }

        public boolean shouldBePublished() {
            return this.gradleModuleDescriptorArtifact.shouldBePublished() && this.derivedArtifact.shouldBePublished();
        }
    }
}

