/*
 * Decompiled with CFR 0.152.
 */
package mill.runner.client;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import mill.main.client.BuildInfo;
import mill.main.client.OutFiles;
import mill.main.client.ServerCouldNotBeStarted;
import mill.main.client.ServerLauncher;
import mill.main.client.Util;
import mill.main.client.lock.Locks;
import mill.runner.client.MillProcessLauncher;

public class MillClientMain {
    public static void main(String[] stringArray) throws Exception {
        Object object;
        boolean bl = false;
        if (stringArray.length > 0) {
            object = stringArray[0];
            boolean bl2 = bl = Arrays.asList("--interactive", "--no-server", "--repl", "--bsp", "--help").contains(object) || ((String)object).startsWith("-i");
        }
        if (!bl && (object = System.getProperty("os.version")) != null && (((String)object).contains("icrosoft") || ((String)object).contains("WSL"))) {
            bl = true;
        }
        if (bl) {
            System.exit(MillProcessLauncher.launchMillNoServer(stringArray));
        } else {
            try {
                object = Util.readOptsFileLines(MillProcessLauncher.millOptsFile());
                Collections.addAll(object, stringArray);
                ServerLauncher serverLauncher = new ServerLauncher(System.in, System.out, System.err, (Map)System.getenv(), object.toArray(new String[0]), null, -1){

                    @Override
                    public void initServer(Path path, boolean bl, Locks locks) throws Exception {
                        MillProcessLauncher.launchMillServer(path, bl);
                    }

                    @Override
                    public void preRun(Path path) throws Exception {
                        MillProcessLauncher.prepareMillRunFolder(path);
                    }
                };
                String string = Util.sha1Hash(BuildInfo.millVersion + MillProcessLauncher.javaHome());
                Path path = Paths.get(OutFiles.out, "mill-server", string);
                int n = serverLauncher.acquireLocksAndRun((Path)path).exitCode;
                if (n == Util.ExitServerCodeWhenVersionMismatch()) {
                    n = serverLauncher.acquireLocksAndRun((Path)path).exitCode;
                }
                System.exit(n);
            }
            catch (ServerCouldNotBeStarted serverCouldNotBeStarted) {
                System.err.println("Could not start a Mill server process.\nThis could be caused by too many already running Mill instances or by an unsupported platform.\n" + serverCouldNotBeStarted.getMessage() + "\n");
                System.err.println("Loading Mill in-process isn't possible.\nPlease check your Mill installation!");
                throw serverCouldNotBeStarted;
            }
            catch (Exception exception) {
                System.err.println("Mill client failed with unknown exception");
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }
}

