/*
 * Decompiled with CFR 0.152.
 */
package mill.api;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import mill.api.Ctx;
import mill.api.PathRef;
import mill.api.PathRef$;
import mill.api.StreamSupport;
import mill.moduledefs.Scaladoc;
import os.Path;
import os.PathChunk;
import os.PathChunk$;
import os.PathConvertible$StringConvertible$;
import os.RelPath;
import os.RelPath$;
import os.SubPath$;
import os.makeDir$all$;
import os.package$;
import os.read$inputStream$;

@Scaladoc(value="/**\n * Misc IO utilities, eventually probably should be pushed upstream into\n * ammonite-ops\n */")
public final class IO$
implements StreamSupport {
    public static final IO$ MODULE$ = new IO$();

    static {
        StreamSupport.$init$(MODULE$);
    }

    @Override
    @Scaladoc(value="/**\n   * Pump the data from the `src` stream into the `dest` stream.\n   */")
    public void stream(InputStream src, OutputStream dest) {
        StreamSupport.stream$(this, src, dest);
    }

    @Scaladoc(value="/**\n   * Unpacks the given `src` path into the context specific destination directory.\n   * @param src The ZIP file\n   * @param dest The relative output folder under the context specific destination directory.\n   * @param ctx The target context\n   * @return The [[PathRef]] to the unpacked folder.\n   */")
    public PathRef unpackZip(Path src, RelPath dest, Ctx.Dest ctx) {
        boolean bl;
        InputStream byteStream = read$inputStream$.MODULE$.apply(src);
        ZipInputStream zipStream = new ZipInputStream(byteStream);
        do {
            ZipEntry zipEntry;
            if ((zipEntry = zipStream.getNextEntry()) == null) {
                bl = false;
                continue;
            }
            if (!zipEntry.isDirectory()) {
                Path entryDest = ctx.dest().$div(PathChunk$.MODULE$.RelPathChunk(dest)).$div(PathChunk$.MODULE$.SubPathChunk(SubPath$.MODULE$.apply(zipEntry.getName(), PathConvertible$StringConvertible$.MODULE$)));
                makeDir$all$.MODULE$.apply(entryDest.$div(PathChunk$.MODULE$.RelPathChunk(package$.MODULE$.up())));
                OutputStream fileOut = Files.newOutputStream(entryDest.toNIO(), new OpenOption[0]);
                this.stream(zipStream, fileOut);
                fileOut.close();
            }
            zipStream.closeEntry();
            bl = true;
        } while (bl);
        return PathRef$.MODULE$.apply(ctx.dest().$div(PathChunk$.MODULE$.RelPathChunk(dest)), PathRef$.MODULE$.apply$default$2(), PathRef$.MODULE$.apply$default$3());
    }

    public RelPath unpackZip$default$2() {
        return (RelPath)package$.MODULE$.rel().$div(new PathChunk.RelPathChunk(RelPath$.MODULE$.fromStringSegments((String[])((Object[])new String[]{"unpacked"}))));
    }

    private IO$() {
    }
}

