/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.attribute;

import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.ForNode;
import guru.nidi.graphviz.attribute.MapAttributes;

public final class Image
implements Attributes<ForNode> {
    private final String path;
    private final Position position;
    private final Scale scale;

    private Image(String path, Position position, Scale scale) {
        this.path = path;
        this.position = position;
        this.scale = scale;
    }

    public static Image of(String path) {
        return new Image(path, Position.MIDDLE_CENTER, Scale.NONE);
    }

    public Image position(Position position) {
        return new Image(this.path, position, this.scale);
    }

    public Image scale(Scale scale) {
        return new Image(this.path, this.position, scale);
    }

    @Override
    public Attributes<? super ForNode> applyTo(MapAttributes<? super ForNode> attrs) {
        attrs.add("image", this.path);
        if (this.position != Position.MIDDLE_CENTER) {
            attrs.add("imagepos", this.position.value);
        }
        if (this.scale != Scale.NONE) {
            attrs.add("imagescale", this.scale.value);
        }
        return attrs;
    }

    public static enum Scale {
        NONE("false"),
        FIT("true"),
        WIDTH("width"),
        HEIGHT("height"),
        BOTH("both");

        String value;

        private Scale(String value) {
            this.value = value;
        }
    }

    public static enum Position {
        TOP_LEFT("tl"),
        TOP_CENTER("tc"),
        TOP_RIGHT("tr"),
        MIDDLE_LEFT("ml"),
        MIDDLE_CENTER("mc"),
        MIDDLE_RIGHT("mr"),
        BOTTOM_LEFT("bl"),
        BOTTOM_CENTER("bc"),
        BOTTOM_RIGHT("br");

        String value;

        private Position(String value) {
            this.value = value;
        }
    }
}

