/*
 * Decompiled with CFR 0.152.
 */
package coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes;

import coursierapi.shaded.coursier.util.shaded.org.jsoup.internal.StringUtil;
import coursierapi.shaded.coursier.util.shaded.org.jsoup.nodes.Node;
import java.util.Objects;

public class Range {
    private static final Position UntrackedPos = new Position(-1, -1, -1);
    private final Position start;
    private final Position end;
    static final Range Untracked = new Range(UntrackedPos, UntrackedPos);

    public Range(Position start, Position end) {
        this.start = start;
        this.end = end;
    }

    public boolean isTracked() {
        return this != Untracked;
    }

    static Range of(Node node, boolean start) {
        String key2;
        String string = key2 = start ? "jsoup.start" : "jsoup.end";
        if (!node.hasAttributes()) {
            return Untracked;
        }
        Object range = node.attributes().userData(key2);
        return range != null ? (Range)range : Untracked;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        if (!this.start.equals(range.start)) {
            return false;
        }
        return this.end.equals(range.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return this.start + "-" + this.end;
    }

    public static class Position {
        private final int pos;
        private final int lineNumber;
        private final int columnNumber;

        public Position(int pos, int lineNumber, int columnNumber) {
            this.pos = pos;
            this.lineNumber = lineNumber;
            this.columnNumber = columnNumber;
        }

        public String toString() {
            return this.lineNumber + "," + this.columnNumber + ":" + this.pos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Position position = (Position)o;
            if (this.pos != position.pos) {
                return false;
            }
            if (this.lineNumber != position.lineNumber) {
                return false;
            }
            return this.columnNumber == position.columnNumber;
        }

        public int hashCode() {
            return Objects.hash(this.pos, this.lineNumber, this.columnNumber);
        }
    }

    public static class AttributeRange {
        static final AttributeRange UntrackedAttr = new AttributeRange(Untracked, Untracked);
        private final Range nameRange;
        private final Range valueRange;

        public AttributeRange(Range nameRange, Range valueRange) {
            this.nameRange = nameRange;
            this.valueRange = valueRange;
        }

        public Range nameRange() {
            return this.nameRange;
        }

        public String toString() {
            StringBuilder sb = StringUtil.borrowBuilder().append(this.nameRange).append('=').append(this.valueRange);
            return StringUtil.releaseBuilder(sb);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AttributeRange that = (AttributeRange)o;
            if (!this.nameRange.equals(that.nameRange)) {
                return false;
            }
            return this.valueRange.equals(that.valueRange);
        }

        public int hashCode() {
            return Objects.hash(this.nameRange, this.valueRange);
        }
    }
}

