/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.navigation.internal;

import com.jgoodies.navigation.Page;
import java.util.prefs.Preferences;

public final class PagePersistencyUtils {
    private static final String PAGE_NAME_KEY = "name";
    private static final String PAGE_PARAMETER_KEY = "parameter";

    private PagePersistencyUtils() {
    }

    public static void storeState(Preferences prefs, Page page) {
        prefs.put(PAGE_NAME_KEY, page.getPersistentPageName());
        String parameter = page.getPersistentPageParameter();
        if (parameter != null) {
            prefs.put(PAGE_PARAMETER_KEY, parameter);
        } else {
            prefs.remove(PAGE_PARAMETER_KEY);
        }
    }

    public static String getStoredName(Preferences prefs, int index) {
        return prefs.get(PAGE_NAME_KEY, null);
    }

    public static String getStoredParameter(Preferences prefs, int index) {
        return prefs.get(PAGE_PARAMETER_KEY, null);
    }
}

