/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.wizard;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.action.AbstractMnemonicAction;
import com.jgoodies.common.swing.focus.JGLayoutFocusTraversalPolicy;
import com.jgoodies.components.JGCardPanel;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.components.util.TextComponentUtils;
import com.jgoodies.dialogs.core.CommandValue;
import com.jgoodies.dialogs.core.CoreDialogResources;
import com.jgoodies.dialogs.core.MessageType;
import com.jgoodies.dialogs.core.internal.JSDLAccessibleRole;
import com.jgoodies.dialogs.core.pane.AbstractStyledPane;
import com.jgoodies.dialogs.core.pane.AbstractStyledPaneVisualConfiguration;
import com.jgoodies.dialogs.core.pane.wizard.WizardModel;
import com.jgoodies.dialogs.core.pane.wizard.WizardPage;
import com.jgoodies.dialogs.core.pane.wizard.WizardPageModel;
import com.jgoodies.dialogs.core.util.JSDLUtils;
import com.jgoodies.layout.builder.ButtonBarBuilder;
import com.jgoodies.layout.builder.FormBuilder;
import com.jgoodies.layout.factories.Paddings;
import com.jgoodies.layout.layout.CellConstraints;
import com.jgoodies.layout.layout.Sizes;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.accessibility.AccessibleRole;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public final class WizardPane
extends AbstractStyledPane<AbstractStyledPaneVisualConfiguration> {
    public static final String PROPERTY_BACK_TEXT = "backText";
    private static final String UI_CLASS_ID = "JSDL.WizardPaneUI";
    private WizardModel wizardModel;
    private WizardAction backAction;
    private WizardAction nextAction;
    private WizardAction finishAction;
    private WizardAction cancelAction;
    private final PropertyChangeListener actionEnablementHandler;
    private String backText;
    private int pageNo;
    private final Map<WizardPage, String> pageMap;

    WizardPane() {
        this(null, null);
    }

    public WizardPane(WizardModel wizardModel) {
        this(wizardModel, null);
    }

    public WizardPane(WizardModel wizardModel, String backText) {
        super(MessageType.PLAIN, new JGCardPanel(), new Object[0]);
        ((JGCardPanel)this.getContent()).setOpaque(false);
        this.setBackText(backText != null ? backText : CoreDialogResources.getString("common.wizard.back"));
        this.initWizardModel(wizardModel);
        this.pageNo = 0;
        this.pageMap = new HashMap<WizardPage, String>();
        this.actionEnablementHandler = this::onWizardPageModelPropertyChange;
        this.updateUI();
    }

    public void addPage(WizardPage page) {
        Preconditions.checkNotNull(page, "The %s must not be null.", "wizard page to add");
        String pageId = String.valueOf(this.pageNo++);
        this.getCardPanel().add(pageId, this.buildCard(page));
        String previousId = this.pageMap.put(page, pageId);
        Preconditions.checkArgument(previousId == null, "You must not add a wizard page twice.\nMain instruction=%s", page.getMainInstructionText());
        if (this.getWizardPage() == null) {
            this.getWizardModel().setWizardPage(page);
        }
    }

    public void addPages(WizardPage ... pages) {
        Preconditions.checkNotNull(pages, "The %s must not be null.", "pages");
        this.addPages(Arrays.asList(pages));
    }

    public void addPages(List<WizardPage> pages) {
        Preconditions.checkNotNull(pages, "The %s must not be null.", "pages");
        for (WizardPage wizardPage : pages) {
            this.addPage(wizardPage);
        }
    }

    public String getBackText() {
        return this.backText;
    }

    public void setBackText(String newText) {
        Preconditions.checkNotBlank(newText, "The %s must not be null, empty, or whitespace.", "Back text");
        String oldText = this.getBackText();
        this.backText = newText;
        this.firePropertyChange(PROPERTY_BACK_TEXT, oldText, newText);
    }

    public WizardModel getWizardModel() {
        return this.wizardModel;
    }

    void initWizardModel(WizardModel model) {
        if (model == null) {
            return;
        }
        this.wizardModel = model;
        this.backAction = new WizardAction(CommandValue.BACK, model, this.getBackText());
        this.nextAction = new WizardAction(CommandValue.NEXT, model, null);
        this.finishAction = new WizardAction(CommandValue.FINISH, model, null);
        this.cancelAction = new WizardAction(CommandValue.CANCEL, model, null);
        this.wizardModel.addPropertyChangeListener("wizardPage", this::onWizardPageChange);
    }

    public WizardPage getWizardPage() {
        return this.getWizardModel().getWizardPage();
    }

    public WizardPageModel getWizardPageModel() {
        return this.getWizardPage() == null ? null : this.getWizardPage().getPageModel();
    }

    @Override
    protected void windowClosing(EventObject e) {
        WizardPageModel pageModel = this.getWizardPageModel();
        if (pageModel != null) {
            pageModel.onWindowClosing(e);
        }
    }

    @Override
    protected void setCommitButtons(JButton ... commitButtons) {
        this.commitButtons = commitButtons;
        this.defaultButton = commitButtons.length == 0 ? null : commitButtons[0];
        this.setCommandBar(this.buildDefaultCommandBar());
    }

    @Override
    protected JComponent buildDefaultCommandBar() {
        this.checkValidButtons();
        ButtonBarBuilder builder = new ButtonBarBuilder();
        if (this.getWizardModel() != null && this.getWizardPage().getAdditionalCommandContent() != null) {
            builder.addFixed(this.getWizardPage().getAdditionalCommandContent()).addGap(Sizes.DLU9);
        }
        builder.addGrowingGap();
        for (int i = 0; i < this.commitButtons.length; ++i) {
            if (i > 0) {
                builder.addRelatedGap();
            }
            builder.addButton((JComponent)this.commitButtons[i]);
        }
        JPanel buttonBar = builder.build();
        buttonBar.setFocusTraversalPolicy(new JGLayoutFocusTraversalPolicy());
        buttonBar.setFocusTraversalPolicyProvider(true);
        return buttonBar;
    }

    @Override
    public Component getInitialFocusOwner() {
        return this.getWizardPage().getDefaultFocusOwner();
    }

    @Override
    protected String layoutGroup() {
        return "WizardPane";
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }

    private JGCardPanel getCardPanel() {
        return (JGCardPanel)this.getContent();
    }

    private JComponent buildCard(WizardPage page) {
        return new WizardPageUIBuilder(this, page).build();
    }

    private void transferFocusToPage() {
        if (this.getWizardPage().getDefaultFocusOwner() != null) {
            this.getWizardPage().getDefaultFocusOwner().requestFocusInWindow();
            return;
        }
        JSDLUtils.transferFocusToDefaultOwner(this, this.commandButtons(), this.defaultButton);
    }

    private void updateCommitButtons() {
        WizardPageModel.PageCommand defaultCommand;
        LinkedList<WizardAction> commitActions = new LinkedList<WizardAction>();
        WizardPageModel model = this.getWizardPageModel();
        if (model.isBackVisible()) {
            commitActions.add(this.backAction);
        }
        if (model.isNextVisible()) {
            commitActions.add(this.nextAction);
        }
        if (model.isFinishVisible()) {
            commitActions.add(this.finishAction);
        }
        if (model.isCancelVisible()) {
            commitActions.add(this.cancelAction);
        }
        this.setCommitCommands(commitActions.toArray());
        if (model.isCancelVisible()) {
            this.setCancelCommand(this.cancelAction);
        }
        if ((defaultCommand = model.getDefaultCommand()) == null) {
            this.setDefaultButton(null);
            return;
        }
        switch (defaultCommand) {
            case BACK: {
                WizardPane.checkVisibleDefaultButton(model.isBackVisible(), "Back");
                this.setDefaultCommand(this.backAction);
                break;
            }
            case NEXT: {
                WizardPane.checkVisibleDefaultButton(model.isNextVisible(), "Next");
                this.setDefaultCommand(this.nextAction);
                break;
            }
            case FINISH: {
                WizardPane.checkVisibleDefaultButton(model.isFinishVisible(), "Finish");
                this.setDefaultCommand(this.finishAction);
                break;
            }
            case CANCEL: {
                WizardPane.checkVisibleDefaultButton(model.isCancelVisible(), "Cancel");
                this.setDefaultCommand(this.cancelAction);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown default command: " + (Object)((Object)defaultCommand));
            }
        }
        this.setDefaultButton(this.defaultButton);
    }

    private static void checkVisibleDefaultButton(boolean expression, String buttonName) {
        Preconditions.checkState(expression, "The wizard page's default button %s is invisible.", buttonName);
    }

    private void changePage(WizardPage oldPage, WizardPage newPage) {
        WizardPageModel newPageModel = newPage.getPageModel();
        this.nextAction.setName(newPageModel.getNextText());
        this.finishAction.setName(newPageModel.getFinishText());
        this.cancelAction.setName(newPageModel.getCancelText());
        this.backAction.setEnabled(newPageModel.isBackEnabled());
        this.nextAction.setEnabled(newPageModel.isNextEnabled());
        this.finishAction.setEnabled(newPageModel.isFinishEnabled());
        this.cancelAction.setEnabled(newPageModel.isCancelEnabled());
        this.updateCommitButtons();
        String pageId = this.pageMap.get(newPage);
        Preconditions.checkState(pageId != null, "A wizard page shall become visible that has not been added to the wizard. \nWizard page=%s", newPage);
        this.getCardPanel().showCard(pageId);
        EventQueue.invokeLater(this::transferFocusToPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWizardPageChange(PropertyChangeEvent evt) {
        WizardPage oldPage = (WizardPage)evt.getOldValue();
        WizardPage newPage = (WizardPage)evt.getNewValue();
        if (oldPage != null) {
            WizardPageModel oldPageModel = oldPage.getPageModel();
            oldPageModel.removePropertyChangeListener(this.actionEnablementHandler);
        }
        try {
            this.changePage(oldPage, newPage);
        }
        finally {
            WizardPageModel newPageModel = newPage.getPageModel();
            newPageModel.addPropertyChangeListener(this.actionEnablementHandler);
        }
    }

    private void onWizardPageModelPropertyChange(PropertyChangeEvent evt) {
        WizardPageModel pageModel = (WizardPageModel)evt.getSource();
        switch (evt.getPropertyName()) {
            case "backEnabled": {
                this.backAction.setEnabled(pageModel.isBackEnabled());
                break;
            }
            case "nextEnabled": {
                this.nextAction.setEnabled(pageModel.isNextEnabled());
                break;
            }
            case "finishEnabled": {
                this.finishAction.setEnabled(pageModel.isFinishEnabled());
                break;
            }
            case "cancelEnabled": {
                this.cancelAction.setEnabled(pageModel.isCancelEnabled());
                break;
            }
            case "nextText": {
                this.nextAction.setName(pageModel.getNextText());
                break;
            }
            case "finishText": {
                this.finishAction.setName(pageModel.getFinishText());
                break;
            }
            case "cancelText": {
                this.cancelAction.setName(pageModel.getCancelText());
                break;
            }
        }
    }

    @Override
    protected AccessibleRole getAccessibleRole() {
        return JSDLAccessibleRole.WIZARD_PANE;
    }

    static final class WizardAction
    extends AbstractMnemonicAction {
        private final CommandValue commandValue;
        private final WizardModel wizardModel;

        WizardAction(CommandValue commandValue, WizardModel wizardModel, String markedText) {
            super(markedText);
            this.commandValue = commandValue;
            this.wizardModel = wizardModel;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextComponentUtils.commitImmediately();
            WizardPageModel pageModel = this.wizardModel.getWizardPage().getPageModel();
            if (this.commandValue == CommandValue.BACK) {
                pageModel.onBackPerformed(e);
            } else if (this.commandValue == CommandValue.NEXT) {
                pageModel.onNextPerformed(e);
            } else if (this.commandValue == CommandValue.FINISH) {
                pageModel.onFinishPerformed(e);
            } else if (this.commandValue == CommandValue.CANCEL) {
                pageModel.onCancelPerformed(e);
            } else {
                throw new IllegalStateException("unknown case:" + this.commandValue);
            }
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.commandValue + "]";
        }
    }

    private static class WizardPageUIBuilder {
        private final WizardPane wizardPane;
        private final WizardPage page;

        WizardPageUIBuilder(WizardPane wizardPane, WizardPage page) {
            this.wizardPane = wizardPane;
            this.page = page;
        }

        JComponent build() {
            int marginContentTop = this.page.getMainInstructionLabelsContent() ? 0 : ((AbstractStyledPaneVisualConfiguration)this.wizardPane.getVisualConfiguration()).getMarginContentTop();
            FormBuilder builder = (FormBuilder)((FormBuilder)new FormBuilder().columns("pref, fill:0:grow", new Object[0])).rows("p, %1$sdlu, %2$sdlu, f:d:g", ((AbstractStyledPaneVisualConfiguration)this.wizardPane.getVisualConfiguration()).getMarginHeaderBottom(), marginContentTop);
            JComponent mainInstructionComponent = null;
            if (this.hasMainInstructionText()) {
                int mainInstructionHeight;
                int mainIconHeight;
                Component mainIcon = null;
                if (this.page.getMainInstructionIcon() != null) {
                    mainIcon = this.buildMainIcon();
                    builder.add(mainIcon).xy(1, 1, "right, top");
                }
                mainInstructionComponent = this.buildMainInstruction();
                FontMetrics fontMetrics = ((Component)mainInstructionComponent).getFontMetrics(mainInstructionComponent.getFont());
                int descent = fontMetrics.getDescent();
                int yOffset = (descent - 1) * -2;
                if (mainIcon != null && (mainIconHeight = mainIcon.getPreferredSize().height) > (mainInstructionHeight = ((Component)mainInstructionComponent).getPreferredSize().height)) {
                    yOffset = 0;
                }
                Insets mainOffset = new Insets(yOffset, 0, 0, 0);
                CellConstraints mainConstraints = new CellConstraints(2, 1, 1, 1, CellConstraints.DEFAULT, CellConstraints.CENTER, mainOffset);
                builder.add(mainInstructionComponent).at(mainConstraints);
            }
            builder.add(this.page.getPageContent()).xy(2, 4);
            return builder.build();
        }

        private Component buildMainIcon() {
            JLabel label = new JLabel(this.page.getMainInstructionIcon());
            int gap = UIManager.getInt("WizardPane.default.gap.mainInstruction.iconText");
            label.setBorder(Paddings.createPadding("0, 0, 0, %sdlu", gap));
            return label;
        }

        private JComponent buildMainInstruction() {
            JGComponentFactory factory = JGComponentFactory.getCurrent();
            JLabel c = this.page.getMainInstructionLabelsContent() ? factory.createLabel(this.page.getMainInstructionText()) : factory.createStaticText(this.page.getMainInstructionText(), new Object[0]);
            c.setFont(((AbstractStyledPaneVisualConfiguration)this.wizardPane.getVisualConfiguration()).getHeaderFont());
            c.setForeground(((AbstractStyledPaneVisualConfiguration)this.wizardPane.getVisualConfiguration()).getHeaderForeground());
            return c;
        }

        private boolean hasMainInstructionText() {
            return Strings.isNotBlank(this.page.getMainInstructionText());
        }
    }
}

