/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.pane.form;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.swing.MnemonicUtils;
import com.jgoodies.components.JGComponentFactory;
import com.jgoodies.dialogs.core.internal.JSDLCoreStyleChecker;
import com.jgoodies.dialogs.core.pane.AbstractStyledPaneVisualConfiguration;
import com.jgoodies.dialogs.core.pane.form.FormPane;
import com.jgoodies.dialogs.core.pane.form.FormPaneModel;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SingleSelectionModel;
import javax.swing.UIManager;

public final class TabbedFormPane
extends FormPane {
    private static final String UI_CLASS_ID = "JSDL.TabbedFormPaneUI";

    public TabbedFormPane() {
        this(new FormPane.DefaultFormPaneModel());
    }

    public TabbedFormPane(FormPaneModel model) {
        this(TabbedFormPane.createFormPaneActions(model));
        this.setCloseRequestHandler(model);
    }

    private TabbedFormPane(Object[] commitObjects) {
        super((JComponent)JGComponentFactory.getCurrent().createTabbedPane(), commitObjects);
        this.setBackground(UIManager.getColor("TabbedFormPane.background"));
        ((AbstractStyledPaneVisualConfiguration)this.getVisualConfiguration()).setCommandArea(null);
    }

    public void addTab(String markedTitle, JComponent component) {
        Preconditions.checkNotNull(component, "The %s must not be null.", "tab component");
        String plainTitle = MnemonicUtils.plainText(markedTitle);
        Preconditions.checkNotBlank(plainTitle, "The %s must not be null.", "plain tab title");
        JSDLCoreStyleChecker.getInstance().checkTabTitle(plainTitle);
        this.getTabbedPane().addTab(plainTitle, component);
        MnemonicUtils.configure(this.getTabbedPane(), this.getTabbedPane().getTabCount() - 1, markedTitle);
    }

    public SingleSelectionModel getTabModel() {
        return this.getTabbedPane().getModel();
    }

    protected JTabbedPane getTabbedPane() {
        return (JTabbedPane)this.getContent();
    }

    @Override
    protected String layoutGroup() {
        return "TabbedFormPane";
    }

    @Override
    public String getUIClassID() {
        return UI_CLASS_ID;
    }
}

