/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.dialogs.core.internal;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.internal.BuilderSupport;
import com.jgoodies.common.swing.internal.AncestorSupport;
import com.jgoodies.dialogs.core.JSDLCoreSetup;
import com.jgoodies.dialogs.core.pane.AbstractStyledPane;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.util.EventObject;
import javax.swing.JDialog;

public abstract class AbstractPaneBuilder<P extends AbstractStyledPane<?>, B extends AbstractPaneBuilder<P, B>> {
    protected final BuilderSupport support = new BuilderSupport();
    private Component owner = null;
    protected String title = null;
    private Dialog.ModalityType modalityType = Dialog.DEFAULT_MODALITY_TYPE;
    private Boolean resizable = null;
    private Dimension minimumSize = null;
    private Dimension maximumSize = null;

    protected AbstractPaneBuilder() {
    }

    public final B owner(EventObject evt) {
        return this.owner(AncestorSupport.getWindowFor(evt));
    }

    public final B owner(Component owner) {
        this.support.checkNotCalledTwice("owner");
        this.owner = owner;
        return (B)this;
    }

    public final B title(String title, Object ... args) {
        this.support.checkNotCalledTwice("title");
        this.title = Strings.get(title, args);
        return (B)this;
    }

    protected B modal(boolean modal) {
        return this.modal(modal ? Dialog.DEFAULT_MODALITY_TYPE : Dialog.ModalityType.MODELESS);
    }

    protected B modal(Dialog.ModalityType modalityType) {
        this.support.checkNotCalledTwice("modal");
        this.modalityType = modalityType;
        return (B)this;
    }

    protected B resizable(boolean resizable) {
        this.support.checkNotCalledTwice("resizable");
        this.resizable = resizable;
        return (B)this;
    }

    protected boolean resizableSet() {
        return this.resizable != null;
    }

    protected B minimumSize(Dimension minimumSize) {
        this.support.checkNotCalledTwice("minimumSize");
        this.minimumSize = minimumSize;
        return (B)this;
    }

    protected B minimumSize(int minimumWidth, int minimumHeight) {
        return this.minimumSize(new Dimension(minimumWidth, minimumHeight));
    }

    protected B maximumSize(Dimension maximumSize) {
        this.support.checkNotCalledTwice("maximumSize");
        this.maximumSize = maximumSize;
        return (B)this;
    }

    protected B maximumSize(int maximumWidth, int maximumHeight) {
        return this.maximumSize(new Dimension(maximumWidth, maximumHeight));
    }

    protected JDialog createDialog(P pane) {
        JDialog dialog = ((AbstractStyledPane)pane).createDialog(this.getOwner(), this.getTitle(), this.modalityType);
        dialog.setResizable(this.resizable != null ? this.resizable : JSDLCoreSetup.getDialogResizableDefault());
        if (this.minimumSize != null) {
            dialog.setMinimumSize(this.minimumSize);
        }
        if (this.maximumSize != null) {
            dialog.setMinimumSize(this.maximumSize);
        }
        return dialog;
    }

    protected final void showDialog(P pane) {
        this.createDialog(pane).setVisible(true);
    }

    protected final Object showDialogReturnCommitValue(P pane) {
        this.showDialog(pane);
        return AbstractPaneBuilder.commitValueOrNullIfUninitialized(((AbstractStyledPane)pane).getCommitValue());
    }

    protected final Object showDialogReturnCommitValueOrNullIfCancelled(P pane) {
        this.showDialog(pane);
        return ((AbstractStyledPane)pane).isCancelled() ? null : AbstractPaneBuilder.commitValueOrNullIfUninitialized(((AbstractStyledPane)pane).getCommitValue());
    }

    protected final boolean showDialogReturnCancelled(P pane) {
        this.showDialog(pane);
        return ((AbstractStyledPane)pane).isCancelled();
    }

    protected final boolean showDialogReturnProceed(P pane) {
        this.showDialog(pane);
        return !((AbstractStyledPane)pane).isCancelled();
    }

    protected final boolean hasTitle() {
        return this.title != null;
    }

    protected Component getOwner() {
        return this.owner;
    }

    protected String getTitle() {
        Preconditions.checkNotNull(this.title, "The dialog title must be set.");
        return this.title;
    }

    private static Object commitValueOrNullIfUninitialized(Object commitValue) {
        return commitValue == AbstractStyledPane.UNINITIALIZED_VALUE ? null : commitValue;
    }
}

