/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.application;

import com.jgoodies.application.AbstractResourceMap;
import com.jgoodies.application.ResourceConverter;
import com.jgoodies.application.ResourceConverters;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.application.internal.Exceptions;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.SystemUtils;
import com.jgoodies.common.swing.ScreenScaling;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;

public class DefaultResourceMap
extends AbstractResourceMap {
    private static final Object NULL_RESOURCE = new String("Null resource");
    private static final Logger LOGGER = Logger.getLogger(DefaultResourceMap.class.getName());
    private static final Evaluator DEFAULT_EVALUATOR = new DefaultEvaluator();
    private static final String DETAILED_MISSING_RESOURCE_EXCEPTIONS_KEY = "DefaultResourceMap.detailedMissingResourceExceptions";
    private static boolean detailedMissingResourceExceptionsEnabled = DefaultResourceMap.getDetailedMissingResourceExceptionEnabledFromSystemProperties();
    private final Locale locale;
    private final String resourceParentPath;
    private final Evaluator evaluator;
    private ResourceBundle bundle;
    private boolean bundleSearched;
    private Map<String, Object> cache;
    private static int counter = 0;

    public DefaultResourceMap(ResourceMap parent, ResourceBundle bundle, ClassLoader classLoader) {
        this(parent, bundle, classLoader, DEFAULT_EVALUATOR);
    }

    public DefaultResourceMap(ResourceMap parent, ResourceBundle bundle, ClassLoader classLoader, Evaluator evaluator) {
        this(parent, bundle.getBaseBundleName(), null, classLoader, evaluator);
        this.bundle = bundle;
        this.bundleSearched = true;
    }

    public DefaultResourceMap(ResourceMap parent, String baseName, Locale locale, ClassLoader classLoader) {
        this(parent, baseName, locale, classLoader, DEFAULT_EVALUATOR);
    }

    public DefaultResourceMap(ResourceMap parent, String baseName, Locale locale, ClassLoader classLoader, Evaluator evaluator) {
        super(parent, baseName, classLoader);
        this.locale = locale;
        this.evaluator = evaluator;
        this.resourceParentPath = DefaultResourceMap.resourceParentPath(baseName);
    }

    public static boolean getDetailedMissingResourceExceptionsEnabled() {
        return detailedMissingResourceExceptionsEnabled;
    }

    public static void setDetailedMissingResourceExceptionsEnabled(boolean enabled) {
        detailedMissingResourceExceptionsEnabled = enabled;
    }

    private static boolean getDetailedMissingResourceExceptionEnabledFromSystemProperties() {
        String property = System.getProperty(DETAILED_MISSING_RESOURCE_EXCEPTIONS_KEY);
        return "enabled".equalsIgnoreCase(property) || "on".equalsIgnoreCase(property);
    }

    @Override
    public final synchronized ResourceBundle getBundle() {
        if (this.bundleSearched) {
            return this.bundle;
        }
        try {
            this.bundle = this.findBundle(this.getBaseName(), this.locale, this.getClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        this.bundleSearched = true;
        return this.bundle;
    }

    @Override
    public final String getResourceParentPath() {
        return this.resourceParentPath;
    }

    @Override
    public final <T> T getObject(String key, Class<T> type) {
        return this.getObject(this, key, type);
    }

    @Override
    public <T> T getObject(ResourceMap scope, String key, Class<T> type) {
        ResourceConverter converter;
        Object value;
        Preconditions.checkNotNull(scope, "The %s must not be null.", "scope");
        Preconditions.checkNotNull(key, "The %s must not be null.", "key");
        Preconditions.checkNotNull(type, "The %s must not be null.", "type");
        ResourceBundle rBundle = this.getBundle();
        boolean isDefaultResourceMap = scope instanceof DefaultResourceMap;
        if (this.getParent() == null) {
            if (rBundle == null) {
                throw new MissingResourceException("Missing resource bundle " + this.getBaseName(), this.getBaseName(), null);
            }
            value = isDefaultResourceMap ? ((DefaultResourceMap)scope).getResource(rBundle, key, scope) : scope.getObject(key, type);
        } else {
            if (rBundle == null || !rBundle.containsKey(key)) {
                return this.getParent().getObject(scope, key, type);
            }
            value = this.getResource(rBundle, key, scope);
        }
        boolean evaluated = false;
        if (value instanceof String) {
            String evaluatedString = this.evaluator.evaluate(scope, key, (String)value);
            boolean bl = evaluated = evaluatedString != value;
            if (evaluated) {
                if (isDefaultResourceMap) {
                    ((DefaultResourceMap)scope).putResource(key, evaluatedString);
                }
                value = evaluatedString;
            }
        }
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        if (value instanceof CachedResource) {
            CachedResource cachedValue = (CachedResource)value;
            if (type == String.class) {
                return type.cast(cachedValue.evaluatedString);
            }
            if (type.isInstance(cachedValue.convertedObject)) {
                return type.cast(cachedValue.convertedObject);
            }
            value = cachedValue.evaluatedString;
            if (value == null) {
                return null;
            }
        }
        if (!(value instanceof String)) {
            this.wrongType(key, value, type);
        }
        if ((converter = ResourceConverters.forType(type)) == null) {
            throw new Exceptions.ResourceConversionException("No resource converter found for type " + type, this, key, "" + value);
        }
        Class<T> returnType = type;
        String trimmedValue = ((String)value).trim();
        T convertedValue = returnType.cast(converter.convert(this, key, trimmedValue, type));
        if (!evaluated) {
            this.putResource(key, (String)value, convertedValue);
        } else if (isDefaultResourceMap) {
            ((DefaultResourceMap)scope).putResource(key, (String)value, convertedValue);
        }
        return convertedValue;
    }

    protected ResourceBundle findBundle(String aBaseName, Locale aLocale, ClassLoader loader) {
        return ResourceBundle.getBundle(aBaseName, aLocale, this.getClassLoader());
    }

    private static String resourceParentPath(String baseName) {
        int index = baseName.lastIndexOf(46);
        return index == -1 ? "" : baseName.substring(0, index).replace('.', '/') + "/";
    }

    private void wrongType(String key, Object value, Class<?> type) {
        throw new ClassCastException("The resource value must either be a String or " + type.getName() + "\nBundle base name=" + this.getBaseName() + "\nkey=" + key + "\nvalue=" + value + "\nvalue type= " + (value == null ? "null" : value.getClass().getName()) + "\nreturn type=" + type);
    }

    private Object getResource(ResourceBundle rBundle, String key, ResourceMap scope) {
        Object value;
        if (this.cache != null && (value = this.cache.get(key)) != null) {
            return value == NULL_RESOURCE ? null : value;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("Resource bundle access #%1$04d key=%2$s; bundle=%3$s", ++counter, key, this.getBaseName()));
        }
        if (!detailedMissingResourceExceptionsEnabled) {
            return rBundle.getObject(key);
        }
        try {
            return rBundle.getObject(key);
        }
        catch (MissingResourceException cause) {
            StringBuilder builder = new StringBuilder(cause.getMessage());
            builder.append("\nBase name=");
            builder.append(this.getBaseName());
            builder.append("\nResource map chain=");
            for (ResourceMap map = scope; map != null; map = map.getParent()) {
                builder.append("\n    ");
                builder.append(map.getBaseName());
            }
            throw new MissingResourceException(builder.toString(), cause.getClassName(), key);
        }
    }

    Object getCachedResourceString(String key) {
        if (this.cache == null) {
            return null;
        }
        Object value = this.cache.get(key);
        if (value == null) {
            return null;
        }
        if (value == NULL_RESOURCE) {
            return null;
        }
        return ((CachedResource)value).evaluatedString;
    }

    Object getCachedResourceObject(String key) {
        if (this.cache == null) {
            return null;
        }
        Object value = this.cache.get(key);
        if (value == null) {
            return null;
        }
        if (value == NULL_RESOURCE) {
            return null;
        }
        return ((CachedResource)value).convertedObject;
    }

    boolean cacheContainsKey(String key) {
        return this.cache != null && this.cache.containsKey(key);
    }

    private void putResource(String key, String evaluatedString, Object convertedObject) {
        Object entry = convertedObject == null ? NULL_RESOURCE : new CachedResource(evaluatedString, convertedObject);
        this.cachePut(key, entry);
    }

    private void putResource(String key, String evaluatedString) {
        this.cachePut(key, new CachedResource(evaluatedString, null));
    }

    private void cachePut(String key, Object entry) {
        if (this.cache == null) {
            this.cache = new ConcurrentHashMap<String, Object>(20);
        }
        this.cache.put(key, entry);
    }

    static final class CachedResource {
        final String evaluatedString;
        final Object convertedObject;

        private CachedResource(String evaluatedString, Object convertedObject) {
            this.evaluatedString = evaluatedString;
            this.convertedObject = convertedObject;
        }
    }

    public static class DefaultEvaluator
    implements Evaluator {
        @Override
        public String evaluate(ResourceMap scope, String key, String expr) {
            String expandedExpr;
            int cursor = 0;
            int start = expr.indexOf("${", cursor);
            if (start == -1) {
                return expr;
            }
            if ("null}".equals(expr.substring(start + 2).trim()) && !DefaultEvaluator.isQuote(expr, start)) {
                return null;
            }
            StringBuilder result = new StringBuilder();
            boolean nonNullValue = false;
            do {
                String variableValue;
                int end;
                if (start > 0 && expr.charAt(start - 1) == '\\') {
                    if (start > 1 && expr.charAt(start - 2) == '\\') {
                        result.append(expr.substring(cursor, start - 2));
                        cursor = start - 1;
                    } else {
                        result.append(expr.substring(cursor, start - 1));
                        result.append("${");
                        nonNullValue = true;
                        cursor = start + 2;
                        start = expr.indexOf("${", cursor);
                        continue;
                    }
                }
                if ((end = expr.indexOf(125, start)) <= start + 2) {
                    String rest = expr.substring(cursor);
                    throw new Exceptions.ResourceEvaluationException("Missing closing brace '}' in \"" + rest + "\"", scope, key, expr);
                }
                String variableName = expr.substring(start + 2, end);
                if (key.equals(variableName)) {
                    throw new Exceptions.ResourceEvaluationException("Resource expression refers to its defining key.", scope, key, expr);
                }
                if (variableName.startsWith("$")) {
                    variableValue = this.evaluateSystemVariable(scope, variableName, key, expr);
                } else {
                    String optionSuffix = this.extractOptionSuffix(scope, variableName, key, expr);
                    if (optionSuffix == null) {
                        try {
                            variableValue = scope.getString(variableName, new Object[0]);
                        }
                        catch (MissingResourceException e) {
                            throw new Exceptions.ResourceEvaluationException("Undefined variable \"" + variableName + "\"", scope, key, expr, e);
                        }
                    }
                    int prefixLength = variableName.length() - (optionSuffix.length() + 2);
                    String variablePrefix = variableName.substring(0, prefixLength);
                    String optionValue = this.evaluateSystemVariable(scope, optionSuffix, key, expr);
                    String specificVariableName = variablePrefix + optionValue;
                    try {
                        variableValue = scope.getString(specificVariableName, new Object[0]);
                    }
                    catch (MissingResourceException e1) {
                        try {
                            variableValue = scope.getString(variablePrefix + "default", new Object[0]);
                        }
                        catch (MissingResourceException e2) {
                            throw new Exceptions.ResourceEvaluationException("Undefined option variable \"" + variablePrefix.substring(0, variablePrefix.length() - 1) + "\"", scope, key, expr, e2);
                        }
                    }
                }
                result.append(expr.substring(cursor, start));
                result.append(variableValue);
                nonNullValue = nonNullValue || variableValue != null;
                cursor = end + 1;
                start = expr.indexOf("${", cursor);
            } while (start != -1);
            nonNullValue = nonNullValue || cursor != expr.length();
            result.append(expr.substring(cursor));
            String string = expandedExpr = nonNullValue ? result.toString() : null;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer(String.format("Resource expression \"%1$s\" expands to \"%2$s\".", expr, expandedExpr));
            }
            return expandedExpr;
        }

        protected String extractOptionSuffix(ResourceMap scope, String variableName, String key, String expr) {
            int start = variableName.indexOf(91);
            if (start == -1) {
                return null;
            }
            int end = variableName.indexOf(93, start);
            if (end <= start + 1) {
                String rest = variableName.substring(start);
                throw new Exceptions.ResourceEvaluationException("Missing closing bracket ']' in \"" + rest + "\".", scope, key, expr);
            }
            return variableName.substring(start + 1, end);
        }

        protected String evaluateSystemVariable(ResourceMap scope, String systemVariableName, String key, String expr) {
            String value = this.evaluateSpecialVariable(systemVariableName);
            if (value != null) {
                return value;
            }
            String systemPropertyKey = systemVariableName.substring(1);
            String systemPropertyValue = DefaultEvaluator.getSystemProperty(systemPropertyKey);
            if (systemPropertyValue != null) {
                return systemPropertyValue;
            }
            throw new Exceptions.ResourceEvaluationException("Undefined system variable \"" + systemVariableName + "\".", scope, key, expr);
        }

        protected String evaluateSpecialVariable(String variableName) {
            if ("$laf".equals(variableName)) {
                return UIManager.getLookAndFeel().getID().toLowerCase(Locale.ENGLISH);
            }
            if ("$os".equals(variableName)) {
                if (SystemUtils.IS_OS_WINDOWS) {
                    return "win";
                }
                if (SystemUtils.IS_OS_MAC) {
                    return "mac";
                }
                if (SystemUtils.IS_OS_LINUX) {
                    return "linux";
                }
                if (SystemUtils.IS_OS_SOLARIS) {
                    return "solaris";
                }
                return "default";
            }
            if ("$scale".equals(variableName)) {
                return ScreenScaling.isScale100() ? "100" : "200";
            }
            return null;
        }

        protected static String getSystemProperty(String key) {
            try {
                return System.getProperty(key);
            }
            catch (SecurityException e) {
                LOGGER.warning("Can't access the System property " + key + ".");
                return "";
            }
        }

        protected static boolean isQuote(String expr, int start) {
            return start > 0 && expr.charAt(start - 1) == '\\' && (start <= 1 || expr.charAt(start - 2) != '\\');
        }
    }

    public static interface Evaluator {
        public String evaluate(ResourceMap var1, String var2, String var3);
    }
}

