/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.basics.format;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.format.AbstractWrappedDateFormat;
import com.jgoodies.common.format.EmptyDateFormat;
import com.jgoodies.common.internal.DateUtils;
import com.jgoodies.common.internal.ResourceBundleAccessor;
import com.jgoodies.common.resource.StringResourceAccessor;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.util.Date;
import java.util.ResourceBundle;

public final class RelativeDateFormat
extends AbstractWrappedDateFormat {
    private static final String KEY_YESTERDAY = "RelativeDate.yesterday";
    private static final String KEY_TODAY = "RelativeDate.today";
    private static final String KEY_TOMORROW = "RelativeDate.tomorrow";
    private static final NumberFormat INTEGER_FORMAT = NumberFormat.getIntegerInstance();
    private static final ResourceMap RESOURCES = Application.getResourceMap(RelativeDateFormat.class);
    private final boolean useOutputShortcuts;
    private final boolean allowRelativeInput;
    private StringResourceAccessor resources;

    public RelativeDateFormat() {
        this(DateFormat.getDateInstance(), true, true);
    }

    public RelativeDateFormat(DateFormat delegate, boolean useOutputShortcuts, boolean allowRelativeInput) {
        super(delegate);
        this.useOutputShortcuts = useOutputShortcuts;
        this.allowRelativeInput = allowRelativeInput;
        this.setResources(RESOURCES);
    }

    public static Format getDefaultEditDateFormat() {
        return RelativeDateFormat.createDateFormat(2, true, true);
    }

    public static Format getDefaultDisplayDateFormat() {
        return RelativeDateFormat.createDateFormat(2, true, false);
    }

    public static Format getDefaultPrintDateFormat() {
        return RelativeDateFormat.createDateFormat(3, false, false);
    }

    private static Format createDateFormat(int style, boolean useOutputShortcuts, boolean allowRelativeInput) {
        return new EmptyDateFormat(new RelativeDateFormat(DateFormat.getDateInstance(style), useOutputShortcuts, allowRelativeInput));
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        if (date == null) {
            return toAppendTo;
        }
        if (this.useOutputShortcuts && DateUtils.isYesterday(date)) {
            return toAppendTo.append(this.getResourceString(KEY_YESTERDAY));
        }
        if (this.useOutputShortcuts && DateUtils.isToday(date)) {
            return toAppendTo.append(this.getResourceString(KEY_TODAY));
        }
        if (this.useOutputShortcuts && DateUtils.isTomorrow(date)) {
            return toAppendTo.append(this.getResourceString(KEY_TOMORROW));
        }
        return this.delegate.format(date, toAppendTo, fieldPosition);
    }

    @Override
    public Date parse(String source, ParsePosition pos) {
        int storedIndex = pos.getIndex();
        Date date = this.delegate.parse(source, pos);
        if (date != null || !this.allowRelativeInput) {
            return date;
        }
        pos.setIndex(storedIndex);
        Number offsetDays = INTEGER_FORMAT.parse(source, pos);
        if (offsetDays == null) {
            return null;
        }
        return DateUtils.toDate(LocalDate.now().plusDays(offsetDays.intValue()));
    }

    public StringResourceAccessor getResources() {
        return this.resources;
    }

    public void setResources(StringResourceAccessor resources) {
        this.resources = Preconditions.checkNotNull(resources, "The %s must not be null.", "resources");
    }

    public void setResourceBundle(ResourceBundle bundle) {
        this.setResources(new ResourceBundleAccessor(bundle));
    }

    private String getResourceString(String key) {
        return this.resources.getString(key, new Object[0]);
    }
}

