/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.argo.uml.diagram.ui;

import java.beans.PropertyChangeEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.argouml.model.Model;
import org.argouml.uml.diagram.deployment.DeploymentDiagramGraphModel;
import org.dbuml.base.controller.CreateActions;
import org.dbuml.base.model.DBModelFacade;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingMode;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.ModeManager;

public class DBDeploymentDiagramGraphModel
extends DeploymentDiagramGraphModel {
    static final long serialVersionUID = 1003748292917485298L;

    public List getPorts(Object nodeOrEdge) {
        List res = super.getPorts(nodeOrEdge);
        if (Model.getFacade().isAPackage(nodeOrEdge)) {
            res.add(nodeOrEdge);
        }
        return res;
    }

    public List getInEdges(Object port) {
        List res = super.getInEdges(port);
        if (Model.getFacade().isAPackage(port)) {
            Iterator it = Model.getFacade().getSupplierDependencies(port).iterator();
            while (it.hasNext()) {
                res.add(it.next());
            }
            it = Model.getFacade().getSpecializations(port).iterator();
            while (it.hasNext()) {
                res.add(it.next());
            }
        }
        return res;
    }

    public boolean canAddNode(Object node) {
        if (node == null) {
            return false;
        }
        if (this.containsNode(node)) {
            return false;
        }
        return Model.getFacade().isANode(node) || Model.getFacade().isAComponent(node) || Model.getFacade().isAClass(node) || Model.getFacade().isAInterface(node) || Model.getFacade().isAObject(node) || Model.getFacade().isANodeInstance(node) || Model.getFacade().isAComponentInstance(node) || Model.getFacade().isAPackage(node);
    }

    public void vetoableChange(PropertyChangeEvent pce) {
        if ("ownedElement".equals(pce.getPropertyName())) {
            Vector oldOwned = (Vector)pce.getOldValue();
            Object eo = pce.getNewValue();
            Object me = Model.getFacade().getModelElement(eo);
            if (oldOwned.contains(eo)) {
                if (Model.getFacade().isANode(me)) {
                    this.removeNode(me);
                }
                if (Model.getFacade().isANodeInstance(me)) {
                    this.removeNode(me);
                }
                if (Model.getFacade().isAComponent(me)) {
                    this.removeNode(me);
                }
                if (Model.getFacade().isAComponentInstance(me)) {
                    this.removeNode(me);
                }
                if (Model.getFacade().isAClass(me)) {
                    this.removeNode(me);
                }
                if (Model.getFacade().isAInterface(me)) {
                    this.removeNode(me);
                }
                if (Model.getFacade().isAObject(me)) {
                    this.removeNode(me);
                }
                if (Model.getFacade().isAAssociation(me)) {
                    this.removeEdge(me);
                }
                if (Model.getFacade().isADependency(me)) {
                    this.removeEdge(me);
                }
                if (Model.getFacade().isALink(me)) {
                    this.removeEdge(me);
                }
                if (Model.getFacade().isAPackage(me)) {
                    this.removeEdge(me);
                }
            }
        }
    }

    public Object connect(Object fromPort, Object toPort, Object edgeType) {
        Editor curEditor = Globals.curEditor();
        ModeManager modeManager = curEditor.getModeManager();
        FigModifyingMode mode = modeManager.top();
        Hashtable args = mode.getArgs();
        String type = (String)args.get("dbtype");
        if (type != null && type.equals("DBDepend")) {
            if (DBModelFacade.getInstance().representsASchema(fromPort) && DBModelFacade.getInstance().representsADatabase(toPort)) {
                Object connection = super.connect(fromPort, toPort, edgeType);
                CreateActions.createDBDependency(fromPort, toPort, connection);
                return connection;
            }
            return null;
        }
        return super.connect(fromPort, toPort, edgeType);
    }
}

