/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile.data;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import jrm.locale.Messages;
import jrm.profile.data.Software;

public final class SoftwareListRenderer {
    private static final ImageIcon folder_closed_green = new ImageIcon(SoftwareListRenderer.class.getResource("/jrm/resources/folder_closed_green.png"));
    private static final ImageIcon folder_closed_orange = new ImageIcon(SoftwareListRenderer.class.getResource("/jrm/resources/folder_closed_orange.png"));
    private static final ImageIcon folder_closed_red = new ImageIcon(SoftwareListRenderer.class.getResource("/jrm/resources/folder_closed_red.png"));
    private static final ImageIcon folder_closed_gray = new ImageIcon(SoftwareListRenderer.class.getResource("/jrm/resources/folder_closed_gray.png"));
    public static final String[] columns = new String[]{Messages.getString("SoftwareListRenderer.Status"), Messages.getString("SoftwareListRenderer.Name"), Messages.getString("SoftwareListRenderer.Description"), Messages.getString("SoftwareListRenderer.Have"), Messages.getString("SoftwareListRenderer.CloneOf"), Messages.getString("SoftwareListRenderer.Selected")};
    public static final Class<?>[] columnsTypes = new Class[]{Object.class, Object.class, String.class, String.class, Object.class, Boolean.class};
    public static final int[] columnsWidths = new int[]{-20, 40, 200, -45, 40, -20};
    public static final TableCellRenderer[] columnsRenderers = new TableCellRenderer[]{new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Software) {
                super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
                switch (((Software)value).getStatus()) {
                    case COMPLETE: {
                        this.setIcon(folder_closed_green);
                        break;
                    }
                    case PARTIAL: {
                        this.setIcon(folder_closed_orange);
                        break;
                    }
                    case MISSING: {
                        this.setIcon(folder_closed_red);
                        break;
                    }
                    default: {
                        this.setIcon(folder_closed_gray);
                    }
                }
                return this;
            }
            this.setIcon(null);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }, new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Software) {
                return super.getTableCellRendererComponent(table, ((Software)value).getBaseName(), isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }, null, new DefaultTableCellRenderer(){
        {
            this.setHorizontalAlignment(0);
        }
    }, new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Software) {
                super.getTableCellRendererComponent(table, ((Software)value).getBaseName(), isSelected, hasFocus, row, column);
                switch (((Software)value).getStatus()) {
                    case COMPLETE: {
                        this.setIcon(folder_closed_green);
                        break;
                    }
                    case PARTIAL: {
                        this.setIcon(folder_closed_orange);
                        break;
                    }
                    case MISSING: {
                        this.setIcon(folder_closed_red);
                        break;
                    }
                    default: {
                        this.setIcon(folder_closed_gray);
                    }
                }
                return this;
            }
            this.setIcon(null);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }, null};

    private SoftwareListRenderer() {
    }
}

