/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.fix.actions;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import jrm.compressors.Archive;
import jrm.compressors.SevenZipArchive;
import jrm.locale.Messages;
import jrm.profile.data.Container;
import jrm.profile.data.EntityBase;
import jrm.profile.data.Entry;
import jrm.profile.fix.actions.EntryAction;
import jrm.ui.progress.ProgressHandler;

public class AddEntry
extends EntryAction {
    private final EntityBase entity;

    public AddEntry(EntityBase entity, Entry entry) {
        super(entry);
        this.entity = entity;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doAction(FileSystem dstfs, ProgressHandler handler, int i, int max) {
        Path dstpath = dstfs.getPath(this.entity.getName(), new String[0]);
        handler.setProgress(null, null, null, this.progress(i, max, String.format(Messages.getString("AddEntry.Adding"), this.entity.getName())));
        Path srcpath = null;
        try {
            if (dstpath.getParent() != null) {
                Files.createDirectories(dstpath.getParent(), new FileAttribute[0]);
            }
            if (this.entry.parent.getType() == Container.Type.DIR) {
                srcpath = this.entry.parent.file.toPath().resolve(this.entry.file);
                Files.copy(srcpath, dstpath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
            if (this.entry.parent.getType() == Container.Type.ZIP) {
                try (FileSystem srcfs = FileSystems.newFileSystem(this.entry.parent.file.toPath(), null);){
                    srcpath = srcfs.getPath(this.entry.file, new String[0]);
                    Files.copy(srcpath, dstpath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    boolean bl = true;
                    return bl;
                }
            }
            if (this.entry.parent.getType() != Container.Type.SEVENZIP) return false;
            try (SevenZipArchive srcarchive = new SevenZipArchive(this.entry.parent.file);){
                if (srcarchive.extract(this.entry.file) == null) return false;
                srcpath = new File(srcarchive.getTempDir(), this.entry.file).toPath();
                Files.copy(srcpath, dstpath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("add from " + this.entry.parent.file + "@" + srcpath + " to " + this.parent.container.file.getName() + "@" + dstpath + " failed");
        }
        return false;
    }

    @Override
    public boolean doAction(Path target, ProgressHandler handler, int i, int max) {
        Path dstpath = target.resolve(this.entity.getName());
        handler.setProgress(null, null, null, this.progress(i, max, String.format(Messages.getString("AddEntry.Adding"), this.entity.getName())));
        Path srcpath = null;
        try {
            if (this.entry.parent.getType() == Container.Type.ZIP) {
                try (FileSystem srcfs = FileSystems.newFileSystem(this.entry.parent.file.toPath(), null);){
                    srcpath = srcfs.getPath(this.entry.file, new String[0]);
                    if (dstpath.getParent() != null) {
                        Files.createDirectories(dstpath.getParent(), new FileAttribute[0]);
                    }
                    Files.copy(srcpath, dstpath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable e) {
                    System.err.println("add from " + this.entry.parent.file.getName() + "@" + this.entry.file + " to " + this.parent.container.file.getName() + "@" + this.entity.getName() + " failed");
                }
            } else if (this.entry.parent.getType() == Container.Type.SEVENZIP) {
                try (SevenZipArchive srcarchive = new SevenZipArchive(this.entry.parent.file);){
                    if (srcarchive.extract(this.entry.file) != null) {
                        srcpath = new File(srcarchive.getTempDir(), this.entry.file).toPath();
                        if (dstpath.getParent() != null) {
                            Files.createDirectories(dstpath.getParent(), new FileAttribute[0]);
                        }
                        Files.copy(srcpath, dstpath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                srcpath = this.entry.parent.file.toPath().resolve(this.entry.file);
                if (dstpath.getParent() != null) {
                    Files.createDirectories(dstpath.getParent(), new FileAttribute[0]);
                }
                Files.copy(srcpath, dstpath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("add from " + this.entry.parent.file.getName() + "@" + srcpath + " to " + this.parent.container.file.getName() + "@" + dstpath + " failed");
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doAction(Archive archive, ProgressHandler handler, int i, int max) {
        handler.setProgress(null, null, null, this.progress(i, max, String.format(Messages.getString("AddEntry.Adding"), this.entity.getName())));
        if (this.entry.parent.getType() == Container.Type.ZIP) {
            try (FileSystem srcfs = FileSystems.newFileSystem(this.entry.parent.file.toPath(), null);){
                boolean bl2 = archive.add_stdin(Files.newInputStream(srcfs.getPath(this.entry.file, new String[0]), new OpenOption[0]), this.entity.getName()) == 0;
                return bl2;
            }
            catch (Throwable e) {
                System.err.println("add from " + this.entry.parent.file.getName() + "@" + this.entry.file + " to " + this.parent.container.file.getName() + "@" + this.entity.getName() + " failed");
                return false;
            }
        }
        if (this.entry.parent.getType() != Container.Type.SEVENZIP) return false;
        try (SevenZipArchive srcarchive = new SevenZipArchive(this.entry.parent.file);){
            if (srcarchive.extract(this.entry.file) == null) return false;
            boolean bl = archive.add(srcarchive.getTempDir(), this.entry.file) == 0;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public String toString() {
        return String.format(Messages.getString("AddEntry.Add"), this.entry, this.entity);
    }
}

