/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.rundeck.client.api.model.repository.ArtifactActionMessage;
import org.rundeck.client.tool.CommandOutput;
import org.rundeck.client.util.ServiceClient;

public class RepositoryResponseHandler {
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void handle(ServiceClient.WithErrorResponse<ArtifactActionMessage> response, CommandOutput output) throws IOException {
        ArtifactActionMessage msg = response.getResponse().body();
        if (response.isError400()) {
            ArtifactActionMessage err = mapper.readValue(response.getErrorBody().repeatBody().bytes(), ArtifactActionMessage.class);
            err.getErrors().forEach(error -> output.error(error.getMsg()));
        } else if (response.getResponse().code() == 403) {
            output.error("Server returned a 403. Either you don't have access to the API or the repository feature is not enabled.");
        } else if (response.getResponse().code() == 404) {
            output.error("Repository is not enabled, or your Rundeck version is too old. Please ensure you are running Rundeck 3.1.0 or later");
        } else {
            output.output(msg.getMsg());
        }
    }
}

