/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class PrologOutputObjectStream {
    OutputStream os;
    ObjectOutputStream tempObjects;
    ByteArrayOutputStream serializedTemp;
    boolean flushed = false;

    public PrologOutputObjectStream(OutputStream outputStream) throws IOException {
        this(outputStream, false);
    }

    public PrologOutputObjectStream(OutputStream outputStream, boolean bl) throws IOException {
        this.os = outputStream;
        this.serializedTemp = bl ? new MyByteArrayOutputStream() : new ByteArrayOutputStream();
        this.tempObjects = new ObjectOutputStream(this.serializedTemp);
    }

    boolean usingEscapeByte() {
        return this.serializedTemp instanceof MyByteArrayOutputStream;
    }

    public ObjectOutputStream getObjectStream() {
        return this.tempObjects;
    }

    public void flush() throws IOException {
        this.tempObjects.close();
        int n = -1;
        n = this.usingEscapeByte() ? this.size() - ((MyByteArrayOutputStream)this.serializedTemp).escapeCount : this.size();
        new DataOutputStream(this.os).writeInt(n);
        this.serializedTemp.writeTo(this.os);
        this.serializedTemp.close();
        this.os.flush();
        this.flushed = true;
    }

    public void writeObject(Object object) throws IOException {
        if (this.flushed) {
            throw new Error("A PrologOutputObjectStream can be used only once.");
        }
        this.tempObjects.writeObject(object);
    }

    public int size() {
        return this.serializedTemp.size();
    }

    static void dump(ByteArrayOutputStream byteArrayOutputStream) {
        byte[] byArray = byteArrayOutputStream.toByteArray();
        System.out.println("--DUMP of ALL bytes:");
        int n = 0;
        while (n < byArray.length) {
            System.out.println(byArray[n]);
            ++n;
        }
        System.out.println("--END OF DUMP");
    }

    static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        int escapeCount = 0;

        public void write(int n) {
            if (n == 101) {
                super.write(101);
                super.write(1);
                ++this.escapeCount;
            } else if (n == -1) {
                super.write(101);
                super.write(2);
                ++this.escapeCount;
            } else {
                super.write(n);
            }
        }

        public void write(byte[] byArray, int n, int n2) {
            int n3 = 0;
            while (n3 < n2) {
                this.write(byArray[n + n3]);
                ++n3;
            }
        }

        MyByteArrayOutputStream() {
        }
    }
}

