/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import megamek.common.Entity;
import megamek.common.IGame;
import megamek.common.Targetable;
import megamek.common.TeleMissile;
import megamek.common.ToHitData;
import megamek.common.actions.AbstractAttackAction;

public class TeleMissileAttackAction
extends AbstractAttackAction {
    private static final long serialVersionUID = -1054613811287285482L;

    public TeleMissileAttackAction(Entity entity, Targetable targetable) {
        super(entity.getId(), targetable.getTargetType(), targetable.getTargetId());
    }

    public static int getDamageFor(Entity entity) {
        if (entity instanceof TeleMissile) {
            return ((TeleMissile)entity).getDamageValue();
        }
        return 0;
    }

    public ToHitData toHit(IGame iGame) {
        return this.toHit(iGame, iGame.getTarget(this.getTargetType(), this.getTargetId()));
    }

    public ToHitData toHit(IGame iGame, Targetable targetable) {
        Entity entity = this.getEntity(iGame);
        if (entity == null) {
            throw new IllegalStateException("Attacker is null");
        }
        if (targetable == null) {
            return new ToHitData(Integer.MAX_VALUE, "Target is null");
        }
        if (!iGame.getOptions().booleanOption("friendly_fire") && targetable.getTargetType() == 0 && (((Entity)targetable).getOwnerId() == entity.getOwnerId() || ((Entity)targetable).getOwner().getTeam() != 0 && entity.getOwner().getTeam() != 0 && entity.getOwner().getTeam() == ((Entity)targetable).getOwner().getTeam())) {
            return new ToHitData(Integer.MAX_VALUE, "A friendly unit can never be the target of a direct attack.");
        }
        ToHitData toHitData = new ToHitData(2, "base");
        TeleMissile teleMissile = (TeleMissile)entity;
        if (entity.mpUsed > 0) {
            toHitData.addModifier(entity.mpUsed, "thrust used");
        }
        if (teleMissile.getFuel() <= 0) {
            toHitData.addModifier(6, "out of fuel");
        }
        return toHitData;
    }
}

