/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.java.lexer;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.java.lexer._JavaDocLexer;
import org.jetbrains.kotlin.com.intellij.lexer.DocCommentTokenTypes;
import org.jetbrains.kotlin.com.intellij.lexer.JavaDocTokenTypes;
import org.jetbrains.kotlin.com.intellij.lexer.LexerBase;
import org.jetbrains.kotlin.com.intellij.lexer.MergingLexerAdapter;
import org.jetbrains.kotlin.com.intellij.pom.java.LanguageLevel;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.util.text.CharArrayUtil;

public class JavaDocLexer
extends MergingLexerAdapter {
    public JavaDocLexer(@NotNull LanguageLevel level) {
        if (level == null) {
            JavaDocLexer.$$$reportNull$$$0(0);
        }
        this(JavaDocTokenTypes.INSTANCE, level.isAtLeast(LanguageLevel.JDK_1_5));
    }

    private JavaDocLexer(DocCommentTokenTypes tokenTypes, boolean isJdk15Enabled) {
        super(new AsteriskStripperLexer(new _JavaDocLexer(isJdk15Enabled, tokenTypes), tokenTypes), tokenTypes.spaceCommentsTokenSet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "org/jetbrains/kotlin/com/intellij/lang/java/lexer/JavaDocLexer", "<init>"));
    }

    private static class AsteriskStripperLexer
    extends LexerBase {
        private final _JavaDocLexer myFlex;
        private final DocCommentTokenTypes myTokenTypes;
        private CharSequence myBuffer;
        private int myBufferIndex;
        private int myBufferEndOffset;
        private int myTokenEndOffset;
        private int myState;
        private IElementType myTokenType;
        private boolean myAfterLineBreak;
        private boolean myInLeadingSpace;

        public AsteriskStripperLexer(_JavaDocLexer flex, DocCommentTokenTypes tokenTypes) {
            this.myFlex = flex;
            this.myTokenTypes = tokenTypes;
        }

        @Override
        public final void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
            if (buffer == null) {
                AsteriskStripperLexer.$$$reportNull$$$0(0);
            }
            this.myBuffer = buffer;
            this.myBufferIndex = startOffset;
            this.myBufferEndOffset = endOffset;
            this.myTokenType = null;
            this.myTokenEndOffset = startOffset;
            this.myFlex.reset(this.myBuffer, startOffset, endOffset, initialState);
        }

        @Override
        public int getState() {
            return this.myState;
        }

        @Override
        @NotNull
        public CharSequence getBufferSequence() {
            CharSequence charSequence = this.myBuffer;
            if (charSequence == null) {
                AsteriskStripperLexer.$$$reportNull$$$0(1);
            }
            return charSequence;
        }

        @Override
        public int getBufferEnd() {
            return this.myBufferEndOffset;
        }

        @Override
        public final IElementType getTokenType() {
            this.locateToken();
            return this.myTokenType;
        }

        @Override
        public final int getTokenStart() {
            this.locateToken();
            return this.myBufferIndex;
        }

        @Override
        public final int getTokenEnd() {
            this.locateToken();
            return this.myTokenEndOffset;
        }

        @Override
        public final void advance() {
            this.locateToken();
            this.myTokenType = null;
        }

        protected final void locateToken() {
            if (this.myTokenType != null) {
                return;
            }
            this._locateToken();
            if (this.myTokenType == this.myTokenTypes.space()) {
                this.myAfterLineBreak = CharArrayUtil.containLineBreaks(this.myBuffer, this.getTokenStart(), this.getTokenEnd());
            }
        }

        private void _locateToken() {
            if (this.myTokenEndOffset == this.myBufferEndOffset) {
                this.myTokenType = null;
                this.myBufferIndex = this.myBufferEndOffset;
                return;
            }
            this.myBufferIndex = this.myTokenEndOffset;
            if (this.myAfterLineBreak) {
                this.myAfterLineBreak = false;
                while (this.myTokenEndOffset < this.myBufferEndOffset && this.myBuffer.charAt(this.myTokenEndOffset) == '*' && (this.myTokenEndOffset + 1 >= this.myBufferEndOffset || this.myBuffer.charAt(this.myTokenEndOffset + 1) != '/')) {
                    ++this.myTokenEndOffset;
                }
                this.myInLeadingSpace = true;
                if (this.myBufferIndex < this.myTokenEndOffset) {
                    this.myTokenType = this.myTokenTypes.commentLeadingAsterisks();
                    return;
                }
            }
            if (this.myInLeadingSpace) {
                this.myInLeadingSpace = false;
                boolean lf = false;
                while (this.myTokenEndOffset < this.myBufferEndOffset && Character.isWhitespace(this.myBuffer.charAt(this.myTokenEndOffset))) {
                    if (this.myBuffer.charAt(this.myTokenEndOffset) == '\n') {
                        lf = true;
                    }
                    ++this.myTokenEndOffset;
                }
                int state2 = this.myFlex.yystate();
                if (state2 == 4 || this.myTokenEndOffset < this.myBufferEndOffset && (this.myBuffer.charAt(this.myTokenEndOffset) == '@' || this.myBuffer.charAt(this.myTokenEndOffset) == '{' || this.myBuffer.charAt(this.myTokenEndOffset) == '\"' || this.myBuffer.charAt(this.myTokenEndOffset) == '<')) {
                    this.myFlex.yybegin(2);
                }
                if (this.myBufferIndex < this.myTokenEndOffset) {
                    this.myTokenType = lf || state2 == 8 || state2 == 6 || state2 == 16 || state2 == 12 ? this.myTokenTypes.space() : this.myTokenTypes.commentData();
                    return;
                }
            }
            this.flexLocateToken();
        }

        private void flexLocateToken() {
            try {
                this.myState = this.myFlex.yystate();
                this.myFlex.goTo(this.myBufferIndex);
                this.myTokenType = this.myFlex.advance();
                this.myTokenEndOffset = this.myFlex.getTokenEnd();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/java/lexer/JavaDocLexer$AsteriskStripperLexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/java/lexer/JavaDocLexer$AsteriskStripperLexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBufferSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "start";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

